/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.zorder;

import com.aliyun.odps.zorder.Statistics;

public class BinaryConverter {
    public static long convert(String type, Object object, int usefulBits, int maxBits) {
        if (object == null) {
            return 0L;
        }
        if (type == "string") {
            return BinaryConverter.convert((String)object, maxBits);
        }
        if (type == "double") {
            return BinaryConverter.convert((Double)object, usefulBits, maxBits);
        }
        if (type == "float") {
            return BinaryConverter.convert(((Float)object).floatValue(), usefulBits, maxBits);
        }
        if (type == "bigint" || type == "int") {
            return BinaryConverter.convert((Long)object, usefulBits, maxBits);
        }
        throw new RuntimeException("Should never reach here");
    }

    public static long convert(String value, int maxBits) {
        int bytes = (maxBits + 8) / 8;
        while (value.length() < bytes) {
            value = value + '\u0000';
        }
        long bits = 0L;
        char[] str = value.substring(0, bytes).toCharArray();
        for (int i = 0; i != str.length; ++i) {
            bits <<= 8;
            bits |= (long)str[i];
        }
        return bits >>= bytes * 8 - maxBits;
    }

    public static long convert(long value, int usefulBits, int maxBits) {
        if (usefulBits < maxBits) {
            value <<= maxBits - usefulBits;
        } else if (usefulBits > maxBits) {
            value >>= usefulBits - maxBits;
        }
        return value;
    }

    public static long convert(double value, int usefulBits, int maxBits) {
        long bits = BinaryConverter.convert(value);
        return BinaryConverter.convert(bits, usefulBits, maxBits);
    }

    public static long convert(float value, int usefulBits, int maxBits) {
        int bits = BinaryConverter.convert(value);
        return BinaryConverter.convert(bits, usefulBits, maxBits);
    }

    public static long convert(double value) {
        return BinaryConverter.flip(Double.doubleToLongBits(value));
    }

    public static int convert(float value) {
        return BinaryConverter.flip(Float.floatToIntBits(value));
    }

    public static long flip(long value) {
        if (value >= 0L) {
            return value ^ Long.MIN_VALUE;
        }
        return value ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static int flip(int value) {
        if (value >= 0) {
            return value ^ Integer.MIN_VALUE;
        }
        return ~value;
    }

    public static long convertUsingStats(Object object, int usefulBits, int maxBits, Statistics statistics) {
        if (object == null) {
            return 0L;
        }
        if (statistics.type == Statistics.Type.STRING) {
            long value = BinaryConverter.convert((String)object, maxBits);
            long min = BinaryConverter.convert((String)statistics.min, maxBits);
            return BinaryConverter.convert(value - min, maxBits, maxBits);
        }
        if (statistics.type == Statistics.Type.DOUBLE) {
            return BinaryConverter.convert((Double)object - (Double)statistics.min, usefulBits, maxBits);
        }
        if (statistics.type == Statistics.Type.FLOAT) {
            return BinaryConverter.convert(((Float)object).floatValue() - ((Float)statistics.min).floatValue(), usefulBits, maxBits);
        }
        if (statistics.type == Statistics.Type.BIGINT) {
            return BinaryConverter.convert((Long)object - (Long)statistics.min, usefulBits, maxBits);
        }
        if (statistics.type == Statistics.Type.INT) {
            return BinaryConverter.convert((Integer)object - (Integer)statistics.min, usefulBits, maxBits);
        }
        throw new RuntimeException("Should never reach here");
    }
}

