//
//  UEPVerifyEvent.h
//  uep
//
//  Created by 浪浪 on 2021/4/1.
//  Copyright © 2021 Alipay. All rights reserved.
//

#import <uep/uep.h>

typedef enum {
    UEPVerifyStateNone,
    UEPVerifyStateStart,       //核身开始
    UEPVerifyStateProcessing,  //核身开始
    UEPVerifyStateEnd,         //核身结束
    UEPVerifyStateDetail = 4       //结构化核身结束
}UEPVerifyState;

NS_ASSUME_NONNULL_BEGIN

@interface UEPVerifyEvent : UEPEvent

@property(nonatomic, assign)UEPVerifyState state; //核身状态

@property(nonatomic, strong)NSString *verifyMsg; //核身消息，格式化日志

@property(nonatomic, strong)NSString *verifyId;     // 核身业务的唯一标识verifyId

@property(nonatomic, strong)NSString *retCode;      // 核身业务的结果码 eg： 1001 1000等

@property(nonatomic, strong)NSString *verifyType;   // 核身生物校验方式 eg：BIO PWD等

@property(nonatomic, assign)long    spendTime;      // 核身校验耗时(单位ms)

@property(nonatomic, strong)NSString *retMsg;       // 核身生物校验方式结果 "FP_MULTI_INDEX", "RESULT_NOT_AVAILABLE"

@property(nonatomic, strong)NSString *sceneid;      // 核身场景id

@end

NS_ASSUME_NONNULL_END
