//
//  UEPUtil.h
//  uep
//
//  Created by 李春荣 on 2019/12/16.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "UEPEvent.h"
#import <APRemoteLogging/APMonitorPointDataDefines.h>
#import <AntUIKit/UIView+AUKExtend.h>

NS_ASSUME_NONNULL_BEGIN

#define UEPAssert(condition, desc) \
do{\
    __PRAGMA_PUSH_NO_EXTRA_ARG_WARNINGS \
    if (__builtin_expect(!(condition), 0)) {        \
        NSString *__assert_fn__ = [NSString stringWithUTF8String:__PRETTY_FUNCTION__]; \
        __assert_fn__ = __assert_fn__ ? __assert_fn__ : @"<Unknown Function>"; \
        NSString *__assert_file__ = [NSString stringWithUTF8String:__FILE__]; \
        __assert_file__ = __assert_file__ ? __assert_file__ : @"<Unknown File>"; \
        [UEPUtil assertWithFile:__assert_file__ function:__assert_fn__ description:desc]; \
    }                \
    __PRAGMA_POP_NO_EXTRA_ARG_WARNINGS \
                        \
}while(0);

    //NSAssert(condition, desc);  \


#define kUEPCombineTypeKey @"combineType"

#define UEP_TRIM(x) ([x stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceAndNewlineCharacterSet]])

static NSString *const kUEPCombineTypeAuto   = @"auto";
static NSString *const kUEPCombineTypeManual = @"manual";
static NSString *const kUEPCombineTypeMix    = @"mix";

@interface UEPUtil : NSObject

// 自动采集总开关
+ (BOOL)isEnable;

+ (NSString*)xPathForView:(UIView*)view;

+ (NSString*)hashCodeStringForView:(UIResponder*)view;

//往上查到到VC返回， 否者往上找到根window（独立弹层场景）， UI线程调用
+ (UIResponder*)pageForView:(UIView*)view;


+ (NSString*)tokenWithHashCode:(NSString*)hashCode;


+ (void)assertWithFile:(NSString*)fileName
              function:(NSString*)function
           description:(NSString*)desc;

+ (NSString*)pageTypeStr:(UEPageType)pageType;

+ (NSString*)inputTypeStr:(UEPInputType)inputType;

+ (NSString*)inTypeStr:(UEPAppInType)inType;

+ (NSString*)c64OpenIdForSessionId:(NSString*)sessionId;

+ (NSString*)v2ConfigString;

+ (NSString*)manualGPath;

+ (NSString*)manualGpathForHashCode:(NSString *)hashCode isIpv:(BOOL)isIpv;

+ (NSString*)manualClickGpathForSeq:(NSString *)seq;

+ (NSString *)manulStepGpath;

+ (BOOL)isManualIPV:(NSString *)spmId;

+ (BOOL)stringValue:(NSString *)str1 equalTo:(NSString *)str2;

+ (BOOL)dictValue:(NSDictionary *)dict1 equalTo:(NSDictionary *)dict2;

+ (NSString*)generateSeqWithTime:(long long)timestamp;

+ (NSString*)generateClickSeqWithTime:(long long)timestamp;

+ (NSString*)generateExposureSeqWithTime:(long long)timestamp;

+ (NSString*)generateScrollSeqWithTime:(long long)timestamp;

+ (BOOL)isVaildString:(NSString *)str;

// 空对象、count=0的数组或count=0的字典
+ (BOOL)isEmptyData:(id)data;

+ (long long)currentTimestamp;

+ (BOOL)isEmbedWebviewController:(UIViewController *)webviewController;

+ (UEPSwtichState)uepSwitchStateWithSpmId:(NSString *)spmId actionId:(NSString *)actionId extParams:(nullable id)extParams;

+ (nullable NSString*)uepSwitchTagWithSpmId:(NSString *)spmId actionId:(NSString *)actionId extParams:(nullable id)extParams;

+ (NSString *)abtestExperimentData;

+ (void)checkLogSubpagesWithParentPage:(UIViewController *)parentVC pageStart:(BOOL)isStart;

// 判断页面是否是子页面
+ (BOOL)checkChildPageForVC:(UIViewController *)vc;

// 判断页面是否配置强制上报
+ (BOOL)forceReportPageForVC:(UIViewController *)vc;

/**
 按array分割dictionary，输入需要mutable，会剔除filter相同的key并返回
 */
+(NSMutableDictionary *)splitDictionary:(NSMutableDictionary *)dict withArray:(NSArray *) filter;

#ifdef __cplusplus
extern "C" {
#endif
    BOOL safelyUnWrapBoolValue(id value);
    long long safelyUnWrapLonglongValue(id value);
    NSInteger safelyUnWrapIntegerValue(id value);
    float safelyUnWrapFloatValue(id value);
#ifdef __cplusplus
}
#endif



@end

@interface UIViewController (uep)
/**
 过滤当前VC,不需要自动化PV埋点. 默认值为 \c NO.
 */
@property (nonatomic, assign) BOOL skipTrack;

// 标记当前H5 VC作为子页面是否上报。默认值 NO
@property (nonatomic, assign) BOOL reportH5Subpage;

@property (nonatomic, strong) AUKEventLogModel *eventLog_auk;

// 标记当前VC正在释放中
@property (nonatomic, assign) BOOL isDeallocing;

@end


NS_ASSUME_NONNULL_END
