//
//  UEPTaskInterceptor.h
//  uep
//
//  Created by 浪浪 on 2022/2/17.
//  Copyright © 2022 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "UEPBaseTask.h"

NS_ASSUME_NONNULL_BEGIN

@protocol UEPTaskInterceptInterface<NSObject>

// 拦截器实现
// @param taskName          任务配置的name值
// @param bizCode           任务配置的bizCode；bizCode传空时，即对所有bizCode进行处理
// @param type              任务类型，现支持CEP/UEP任务，只有注册了相应类型任务，才会提供相应任务的拦截回调
// @return                  YES 表示拦截， NO表示不拦截
+ (BOOL)shouldInterceptTask:(NSString *)taskName bizCode:(NSString *)bizCode type:(UEPTaskType)type;

@end

// 子类实现CEPCEPTaskInterceptInterface处理拦截逻辑
@interface UEPTaskInterceptor<UEPTaskInterceptInterface> : NSObject

// 工具方法
+ (void)registerInterceptor:(Class)interceptor type:(UEPTaskType)type;

+ (void)registerInterceptor:(Class)interceptor bizCode:(NSString * _Nullable)bizCode type:(UEPTaskType)type;

+ (void)unregisterInterceptor:(Class)interceptor bizCode:(NSString *)bizCode type:(UEPTaskType)type;

@end

NS_ASSUME_NONNULL_END
