//
//  UEPRpcEvent.h
//  uep
//
//  Created by LiMengtian on 2020/10/30.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <uep/uep.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, UEPRpcState) {
    UEPRpcStateNone,
    UEPRpcStateStart,
    UEPRpcStateError,
    UEPRpcStateEnd
};

@interface UEPRpcEvent : UEPEvent

@property (nonatomic, copy) NSString *rpcOperationType;

@property (nonatomic, assign)UEPRpcState rpcState;
@property (nonatomic, assign)NSInteger rpcId;

// 异常或取消时才有
@property (nonatomic, copy) NSError *error;

// 结束状态才有
@property (nonatomic, strong)NSString *traceId;
@property (nonatomic, assign)NSInteger statusCode;
@property (nonatomic, copy) NSDictionary *rpcRespHeader;

// 兼容node开关配置
- (NSString *)operation;

@end

NS_ASSUME_NONNULL_END
