//
//  UEPPageEvent.h
//  uep
//
//  Created by 李春荣 on 2019/12/16.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import "UEPBehaviorEvent.h"
#import "UEPBehaviorProtocol.h"
#import <APRemoteLogging/APMonitorPointDataDefines.h>

NS_ASSUME_NONNULL_BEGIN

// page来源类型src_page 与refer_page的区别
// 示例
// A -> B -> C => B'(返回操作)
// 其中page C的 src_page = B', 而page C的refer_page = B

//页面 显示、隐藏、销毁事件
@interface UEPPageEvent : UEPBehaviorEvent <NSCopying>

//必填参数
@property (nonatomic, assign) UEPageState      pageState;    //显示、隐藏、销毁状态
@property (nonatomic, copy) NSString           *appVersion;  //小程序 应用version
@property (nonatomic, copy) NSString           *sdkVersion;  //小程序/H5 SDKversion
@property (nonatomic, copy) NSString           *srcPageName; //原始页面ClassName

//选填参数
@property (nonatomic, copy) NSString           *spm;         //SPM
@property (nonatomic, copy) NSString           *scm;         //SCM
@property (nonatomic, strong) NSDictionary     *param;       //业务扩展参数
@property (nonatomic, strong) NSData           *bizInfo;     //业务schema化扩展参数
@property (nonatomic, copy) NSString           *eventId;     //业务schema化 对应eventId
@property (nonatomic, copy) NSString           *gpath;       //gpath
@property (nonatomic, assign) BOOL             isIPV;        //是否是IPV页面

@property (nonatomic, strong) NSString         *title;       //页面标题
@property (nonatomic, assign) long             staytime;     //停留时长，仅页面结束状态时有值
@property (nonatomic, assign) BOOL             isChildPage;  //是否是子页面：通过addChildViewController绑定
@property (nonatomic, assign) BOOL             isForceReport;//是否指定强制上报

// 是否前后台触发的页面事件，和push/pop产生的页面事件有区分，曝光op在处理时，push/pop的页面会清除页面缓存的曝光数据，前后台产生的页面事件则不清除
@property (nonatomic, assign)BOOL              isAppStatusChanged;

@end

static const char *kNBSPMInfo_KEY_APPX_MPaaS = "kNBSPMInfo_KEY_APPX";
@interface MPH5SPMToken : NSObject<NSCopying>

@property (nonatomic, copy) NSString *uuid;
@property (nonatomic, weak) UIView * psdContentView;//每个页面的contentView不会变，关联同一页面不同类型埋点数据
@property (nonatomic, assign) SPMPageType pageType;
@end


@interface MPNBSPMInfo : NSObject

@property(nonatomic, strong) NSString *spmId;
@property(nonatomic, strong) MPH5SPMToken *spmToken;
@property(nonatomic, strong) NSString *bizType;
@property(nonatomic, strong) NSString *chInfo;
@property(nonatomic, strong) NSDictionary *spmParams;
@property(nonatomic, strong) NSDictionary *spmDetail;
@property(nonatomic, assign) BOOL isFromAppX;
@property(nonatomic, strong) NSDictionary *uep;
@property(nonatomic, assign) BOOL uepIsTiny;
@property(nonatomic, strong) NSString *scm;

@end


NS_ASSUME_NONNULL_END
