//
//  UEPInputEvent.h
//  uep
//
//  Created by 李春荣 on 2019/12/16.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import "UEPBehaviorEvent.h"

NS_ASSUME_NONNULL_BEGIN

@interface UEPInputEvent : UEPBehaviorEvent

//必填参数 , Native 通过[UEPUtil xPathForView:view] 获取
@property (nonatomic, copy) NSString         *xPath;        //输入控件路径（xPath）

//必填参数， Native 通过[UEPUtil hashCodeStringForView:view] 获取
// @property (nonatomic, copy) NSString         *target;       //控件实例标识（Hash Code）


//必填参数
@property (nonatomic, assign) UEPInputType   inputType;     //输入控件类型

//必填参数
@property (nonatomic, assign) BOOL           changed;       //内容是否变化


//选填参数
@property (nonatomic, copy) NSString         *spm;          //SPM
//选填参数
@property (nonatomic, copy) NSString         *scm;          //SCM
//选填参数
@property (nonatomic, strong) NSDictionary   *param;        //业务扩展参数

//选填参数
@property (nonatomic, strong) NSData         *bizInfo;      //业务schema化扩展参数
//选填参数
@property (nonatomic, copy) NSString         *eventId;      //业务schema化 对应eventId

//选填参数
@property (nonatomic, copy) NSString         *entityId;     //业务控件标识

@property (nonatomic, strong)NSString          *selector;// 前端选择器，前端组件才有

@end

NS_ASSUME_NONNULL_END
