//
//  UEPEventCommit.h
//  uep
//
//  Created by 李春荣 on 2019/12/16.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import "UEPClickEvent.h"

#import "UEPTouchEvent.h"

#import "UEPInputEvent.h"

#import "UEPExposureEvent.h"

#import "UEPScrollEvent.h"

#import "UEPBackEvent.h"

#import "UEPPageEvent.h"

#import "UEPAppStatusEvent.h"

#import "UEPAppInEvent.h"

#import "UEPAppOutEvent.h"

#import "UEPAppRouteEvent.h"

#import "UEPAppRouteBlockEvent.h"

#import "UEPPushEvent.h"

#import "UEPScanEvent.h"

#import "UEPPlayEvent.h"

#import "UEPOperator.h"

NS_ASSUME_NONNULL_BEGIN

@interface UEPEventCommit : NSObject

/* 采集事件统一入口 */
+(void)commitEvent:(UEPEvent*)event;


/* 事件总线注册， 异步回调
 * processOperator 事件处理算子
 * eventTypes 事件类型，支持位或注册多事件类型
 */
+(void)registerProcessOperator:(UEPOperator<UEPProcessOperatorProtocol>*)processOperator
                      forTypes:(UEPEventType)eventTypes;

/* 移除注册的事件总线 */
+(void)unregisterProcessOperator:(UEPOperator<UEPProcessOperatorProtocol>*)processOperator;


@end

NS_ASSUME_NONNULL_END
