//
//  UEPBehaviorEvent.h
//  uep
//
//  Created by 李春荣 on 2019/12/16.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import "UEPEvent.h"
#import "UEPBehaviorProtocol.h"

NS_ASSUME_NONNULL_BEGIN

@class AUKEventLogModel;
typedef void (^UEPEventLogUpdateBlock)(AUKEventLogModel *model, NSInteger eventType);

@interface UEPBehaviorEvent : UEPEvent <NSCopying, UEPBehaviorProtocol>

//必填参数， 可通过 [UEPUtil pageForView:view] 接口获取， 接口需要主线程调用
//此处用strong是避免有的业务在dealloc内调用埋点结束接口，导致设置weak属性crash；uep内部会保证用完page属性置nil
@property (nonatomic, strong) UIResponder    *page;         // 页面VC 或 分享弹层类归属window

//选填参数
@property (nonatomic, assign) UEPageType     pageType;      //页面类型 (native/h5/tiny)
@property (nonatomic, copy) NSString         *appId;        // 页面所属应用appId
@property (nonatomic, copy) NSString         *subPageName;  // 子页面名 (url)，h5/tiny 页面内导航等场景, native暂不传
@property (nonatomic, copy) NSString         *subPageToken; // 子页面实例标识（Hash Code)，h5/tiny 页面内导航等场景, native暂不传
@property (nonatomic, copy) NSString         * __nullable combineType;  // 合并标志，埋点融合用
@property (nonatomic, copy) NSString         *pageName;     // 页面ClassName
@property (nonatomic, strong)NSDictionary    *sdkParams;    // sdk参数，前端日志sdk相关参数

//必填参数， Native 通过[UEPUtil hashCodeStringForView:view] 获取
@property (nonatomic, copy) NSString         *target;       // 控件实例标识（Hash Code）
@property (nonatomic, copy) NSString         *pageHash;     // 页面实例标识（Hash Code)
@property (nonatomic, assign) BOOL           addManualSpmd; // 添加手动埋点
@property (nonatomic, assign) CGSize         size;          // 控件的大小
@property (nonatomic, copy) UEPEventLogUpdateBlock updateBlock; // 业务异步更新数据block

/**
 *  @param target 点击控件对象，可不为UIView
 *  @param eventPage  控件所属页面VC 或 分享弹层类归属window
 */
+ (instancetype)eventWithTarget:(id)target page:(UIResponder *)eventPage;

- (NSDictionary *)getSpmParamWithBizcode:(NSString *)bizCode
                            PageSpmParam:(NSDictionary *)pageInfoSpmParam
                       spmtracker_params:(NSDictionary *)spmtracker_params;

@end


NS_ASSUME_NONNULL_END
