//
//  UEPBaseTaskMgr.h
//  uep
//
//  Created by 浪浪 on 2022/7/20.
//  Copyright © 2022 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "UEPBaseTask.h"
#import "UEPBaseTaskParser.h"
#import "UEPJobListModel.h"

NS_ASSUME_NONNULL_BEGIN

@interface UEPBaseTaskMgr : NSObject

@property(nonatomic, strong)NSMutableDictionary<NSString *, UEPBaseTask *> *tasksInfo;

@property(nonatomic, readonly)UEPJobListModel *listModel;

#pragma mark overwrite

- (UEPBaseTaskParser *)loadParser;

- (const char *_Nullable)uniqueQueueName;

- (NSString *)tasksListSwitchName;

- (UEPTaskType)taskType;

- (BOOL)jobSwitch;

- (BOOL)logSwitch;

- (BOOL)logTestSwitch;

#pragma mark lifecycle

- (void)setup;

- (UEPBaseTask *)registTaskWithCfg:(NSDictionary *)taskCfg;

- (void)unregistTaskWithName:(NSString *)taskName;

- (void)cancelAllTask;

- (UEPBaseTask *)getTask:(NSString *)taskName;

#pragma mark tools

// 任务管理队列（cep/ssp共用）
- (dispatch_queue_t)taskQueue;

// 任务执行队列，运行processEvent,耗时处理
- (dispatch_queue_t)execQueue;

@end

NS_ASSUME_NONNULL_END
