//
//  UEPActUtils.h
//  uep
//
//  Created by 浪浪 on 2020/12/17.
//  Copyright © 2020 Alipay. All rights reserved.
//

#ifndef UEPActUtils_h
#define UEPActUtils_h

typedef enum {
    UEPActRecordStateNormal,
    UEPActRecordStateOpen,
    UEPActRecordStateClose
} UEPActRecordState;

typedef enum {
    UEPActTypeApp,
    UEPActTypePage,
    UEPActTypeStartUp,
    UEPActTypeClick
} UEPActType;

typedef enum {
    UEPActNodeTypeSession =     1,
    UEPActNodeTypeApp =         1 << 1,
    UEPActNodeTypeScene =       1 << 2,
    UEPActNodeTypePage =        1 << 3,
    
    //UEPActNodeTypeStartLeafNode, //此枚举后都是叶子节点，新增行为节点类型请加在StartLeafNode后面
    
    UEPActNodeTypeClick =       1 << 4,
    UEPActNodeTypeExpose =      1 << 5,
    UEPActNodeTypeRPC =         1 << 6,
    UEPActNodeTypeScan =        1 << 7,
    UEPActNodeTypePay =         1 << 8,
    UEPActNodeTypeAppOut =      1 << 9,
    UEPActNodeTypePrompt =      1 << 10,
    UEPActNodeTypeKeyboard =      1 << 11,
    
    UEPActNodeTypeFgBg =        1 << 12,
    
    // UEPActNodeTypeAll表示所有的集合，更新时UEPActNodeTypeAll中的UEPActNodeTypeFgBg勿忘更新
    UEPActNodeTypeAll = (UEPActNodeTypeFgBg << 1) - 1
} UEPActNodeType;

#endif /* UEPActUtils_h */
