//
//  UEPActNodeScene.h
//  uep
//
//  Created by 浪浪 on 2021/1/13.
//  Copyright © 2021 Alipay. All rights reserved.
//

#import "UEPActBaseNode.h"
#import "UEPEvent.h"

NS_ASSUME_NONNULL_BEGIN
/**
 page实例节点，subnode是page node,首次打开页面时会同时生成scene node和其访问子节点page node
 */
@interface UEPActNodeScene : UEPActBaseNode

// 业务资源id, 业务打开页面时传递的appId, 即资源的id,和实际启动的应用的appId可能不一致
@property(nonatomic, strong)NSString *pkgId;

// type 场景类型（native/h5/tiny）
@property(nonatomic, assign)UEPageType sceneType;

// 场景可读标识类别 （类名/url/路径）
@property(nonatomic, strong)NSString *sceneName;

@property(nonatomic, strong)NSString *title;

- (NSArray *)pageList;

- (NSString *)sceneTypeStr;

@end

NS_ASSUME_NONNULL_END
