//
//  QRCode.h
//  libCVEngine
//
//  Created by alibaba on 2018/12/18.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#ifndef QRCode_h
#define QRCode_h

#include <vector>
#include <memory>
#include <map>

#include <stdint.h>

#define PERFORMANCE_LOG
#define WARPPERSPECTIVE_SIZE 384

#define OCV slamcv

#define QRCodeCV_OK                      (0)
#define QRCodeCV_UNKNOWN_ERROR          (-1)
#define QRCodeCV_NOMEM                  (-2)
#define QRCodeCV_DETECT_CORNERS_LESS    (-3)
#define QRCodeCV_INVALID_PARAMS         (-4)

#define EXPORT __attribute__ ((visibility("default")))

typedef struct {
    float x;
    float y;
} qrPoint;

typedef struct {
    uint8_t *data;
    int w;
    int h;
} qrArea;

typedef struct sImgData {
    //!* mode: 0 - scale, 1 - crop *!
    int mode;
    int crop_x;
    int crop_y;
    
    int input_width;
    int input_height;
    int rotation;
    
    int output_width;
    int output_height;
    int fix_width;
    int fix_height;
    int crop_left;
    int crop_top;
    int fill_top;
    int need_rotate;
    
    //!* In Alipay Portal set flag isFillMode = 0 *!
    //!* In Unittest(input file size < 1920x1080) set flag isFillMode = 1 *!
    int isFillMode;
    
    //!* Params from xNN *!
    int m_detectInputWidth;
    int m_detectInputHeight;
    int m_detectOutWidth;
    int m_detectOutHeight;

    //!* Input YUV buffer *!
    uint8_t *input_buffer;
    
    //!* XNN filed *!
    uint8_t *p_preGeo;
    uint8_t *p_qrGeo;
} sImgParams;


//!* Crop/Scale Input Y buffer. *!
//@param s_sImg -> image Y buffer.
//@return value -> OK: buffer memory.
//@             -> Failed: NULL.
extern "C" uint8_t *cropInputBuffer(sImgParams *s_sImg);

//!* Get Image's QRCode Area position points from xNN reslut.*!
//@param s_sImg    -> image Y buffer..
//@param predShape -> xNN result.
//@param qrShape   -> xNN result.
//@param mPoints   -> QRCode Area position points.
//@return value    -> OK: QRCodeCV_OK.
//@                -> Failed: not QRCodeCV_OK.
extern "C" int getQRPoints(sImgParams *s_sImg, std::vector<int> &predShape, std::vector<int> &qrShape, std::vector<std::vector<qrPoint>> &mPoints);
extern "C" int getQRAreas(sImgParams *s_sImg, std::vector<int> &predShape, std::vector<int> &qrShape, std::vector<qrArea> &mROI, std::vector<std::vector<qrPoint>> &mPoints);

//!* Get CVEngine Optimised QRCode Area points from xNN points, result value is in mOptPoints. *!
//@param s_sImg     -> image Y buffer..
//@param mXnnPoints -> QRCode Area position points detected by xNN.
//@param mOptPoints -> CVEngine Optimised QRCode Area points result.
//@return value     -> OK: QRCodeCV_OK.
//@                 -> Failed: not QRCodeCV_OK.
extern "C" int getOptimisedPoints(sImgParams *s_sImg, const std::vector<qrPoint> &mXnnPoints, std::vector<qrPoint> &mOptPoints);
extern "C" int getOptimisedQRAreas(sImgParams *s_sImg, std::vector<int> &predShape, std::vector<int> &qrShape, std::vector<qrArea> &mROI);

//!* Release resource of QRCode *!
extern "C" void QRCodeRelease();

#endif /* QRCode_h */
