/**
 * Copyright (c) 2016 Alipay.Co.Ltd. All rights reserved.
 * Filename: PoseData.h
 * Author:   玄镜(陈爽)
 * Email:    chenshuang.cs@alipay.com
 */

#ifndef __SLAM_POSEDATA_H__
#define __SLAM_POSEDATA_H__

#define SENSOR_DATA_LEN     3
#define POSE_DATA_W         4
#define POSE_DATA_H         4

//#define ENABLE_SLAM_PLANE   1

typedef enum eSensorIOS {
    GYROSCOPE = 0,
    MAGNETIC = 1,
    ACCELEROMETER = 2,
    ROTATION = 3
} eSensorIOS;

typedef enum eUseModeIOS {
    VISION_MODE = 0,
    IMU_MODE = 1,
    FUSE_MODE = 2,
    ROT_FUSE_MODE = 3,
    GRAVITY_FUSE_MODE = 4
} eUseModeIOS;


typedef  struct sSensorData {
    float gyroscope[SENSOR_DATA_LEN];
    float magnetic[SENSOR_DATA_LEN];
    float accelerometer[SENSOR_DATA_LEN];
} sSensorIOS;


typedef struct sSensorItemData {
    float data[3];
    double timestamp;
    eSensorIOS sensorType;
} sSensorItemIOS;


typedef struct sPhyCamData {
    float focus_Length;
    float horizontal_view_angle;
    float vertical_view_angle;
    int sensor_width;
    int sensor_height;
    int fps;
} sPhyCamParaIOS;

typedef struct sVirtualCamData {
    float horisental_fov;
    int screen_width;
    int screen_height;
    float distance;
} sVirtualCamParaIOS;

typedef struct sTrackPicData {
    int width;
    int height;
} sTrackPicParaIOS;

typedef struct sRenderModelData {
    float x;
    float y;
    float z;
    bool clickOn;
} sRenderModelParaIOS;

typedef struct sTargetInfoData {
    int x;
    int y;
    int w;
    int h;
} sTargetInfoDataIOS;

typedef struct sRectInfoData {
    int x;
    int y;
    int width;
    int height;
    bool isLost;
} sRectInfoDataIOS;


/********************************************************************************
 * 平面检测数据结构
 ********************************************************************************/
typedef struct SlamPlaneAnchor {
    int isPlaneValid;
    int isPlaneUpdate;
    int alignment;      //0=Horizontal,1=Vertical.
    float center[3];
    float extent[3];
    float transform[4][4];
} SlamPlaneAnchorIOS;


typedef  struct sPoseData {
    float pose[POSE_DATA_W][POSE_DATA_H];
    bool isValid;
    int retMode; //0(IVALID）, 1(IMU), 2(FUSE), 3(ARKIT)
    
    bool visionInitSuccess;
    long long visionInitCostTime;
    long fastDectedPoints;
    long fastTrackPoints;
    long totalMapPoints;
    long totalKeyFrames;
    
    // location of virtual object in image (x, y)
    float obj_x;
    float obj_y;
    
#ifdef ENABLE_SLAM_PLANE
    // slam平面检测的结果,对IOS APP的返回值.
    SlamPlaneAnchorIOS SlamIOSPlane;
#endif
} sPoseMatrixIOS;


#endif  // __SLAM_POSEDATA_H__
