#pragma once

#include "defs.h"
#include "tensor.h"

namespace TensorUtils {

    EXPORT int alloc(Tensor& tensor, std::string name, std::vector<int> shape, std::string type, void* data, int size, bool reference = false);

    EXPORT void recycle(Tensor &tensor);

    EXPORT int cast(Tensor& from, Tensor& to);

    EXPORT int transform(Tensor& tensor, Image& image, std::string options);

    EXPORT int transform(Tensor& tensor, Image& image, Actions actions);
};
