#pragma once

#include <string>
#include <vector>
#include <memory>

#include "tensor.h"

class TensorProcess;

class EXPORT TensorProcessWrapper {
public:
    struct Options {
        std::string xnn_config = "";
        std::string aes_key = "";
        std::string md5 = "";
    };

public:
    TensorProcessWrapper() = default;
    ~TensorProcessWrapper() = default;

    int get_error() {
        return error_;
    }

    Tensors& get_inputs() {
        return inputs_;
    }

    Tensors& get_outputs() {
        return outputs_;
    }

    bool load(std::string license, std::string model_path, Options& options);
    Tensors inference(Tensors& inputs, Tensors& outputs);
    void release();

private:
    int error_;
    Tensors inputs_;
    Tensors outputs_;
    std::shared_ptr<TensorProcess> tensor_processor_;
};