#pragma once
#include <string>
#include <memory>
#include <set>

class XnnUtils;
class TemplateBasedPoseMatcher {
public:
    TemplateBasedPoseMatcher() = default;
    ~TemplateBasedPoseMatcher() = default;

    bool init(std::string xnnModelPath, std::string xnnConfig);
    int match(float *kps, int index);
    void release();

    bool isIndexSupported(int index);

private:
    std::shared_ptr<XnnUtils> engine_ = nullptr;
    std::set<int> supportedIndex_;
};

