//
//  super_resolution_wrapper.hpp
//  XMedia
//
//  Created by 符婷 on 2022/3/8.
//  Copyright © 2022 Alipay. All rights reserved.
//

#ifndef super_resolution_wrapper_hpp
#define super_resolution_wrapper_hpp

#include <stdio.h>
#include <string>
#include <vector>
#include <memory>
#include "defs.h"
#ifndef EXPORT
#define EXPORT __attribute__ ((visibility("default")))
#endif

class SR_Engine;
class EXPORT SuperResolutionWrapper {
public:
  SuperResolutionWrapper();
  ~SuperResolutionWrapper();
  int init(const char *packedModelFile, const char *xnnConfig);
  int initWithJson(std::vector<std::string> models);
  int run(uint8_t *pBufy, uint8_t *pBufu, uint8_t *pBufv, int width, int height, int channel, const std::string& format);
  void release();
  const uint8_t* getOutput();
  int getOutputImage(Image& srOutImage);
  int getOutputShape(int& width, int& height, int& channel);
  bool isSupportRes(int width, int height, int channel, const std::string& format);
private:
  SR_Engine* _processor = nullptr;
};

extern "C" void* sr_wrapper_init(const char *model_file, const char *xnnConfig);
extern "C" void sr_wrapper_release(void *sr_wrapper);
extern "C" const uint8_t* sr_wrapper_getOutput(void *sr_wrapper);
extern "C" int sr_wrapper_getOutputShape(void *sr_wrapper, int& width, int& height, int& channel);
extern "C" int sr_wrapper_run(void *sr_wrapper,uint8_t *pBufy, uint8_t *pBufu, uint8_t *pBufv, int width, int height, int channel, const std::string& format);
extern "C" bool sr_wrapper_isSupportRes(void *sr_wrapper, int width, int height, int channel, const std::string& format);
#endif
