//
//  live_human_segment_wrapper.hpp
//  XMedia
//
//  Created by david on 2021/8/18.
//  Copyright © 2021 Alipay. All rights reserved.
//


#ifndef style_transfer_wrapper_hpp
#define style_transfer_wrapper_hpp

#include <stdio.h>
#include <string>
#include <vector>
#include <memory>

#ifdef ANDROID
#include <time.h>
#else
#include <sys/time.h>
#endif

#include "tensor_process_wrapper.h"
#include "tensor_utils.h"
#include "face_track_info.h"

#include "defs.h"

//struct for style transfer result
struct StyleTransResult {
    Image raw_data;
    Image processed_data;

    StyleTransResult() {
        raw_data = Image();
        processed_data = Image();
    }
};

struct STSize {
    float width;
    float height;
};

struct STFrame {
    float x;
    float y;
    float width;
    float height;
};



typedef enum {
    STYLE_TRANSFER_STATUS_SUCCESS = 0,
    STYLE_TRANSFER_STATUS_INVALID_ARGUMENT,
    STYLE_TRANSFER_STATUS_INIT_FAILED,
    STYLE_TRANSFER_STATUS_UNKNOWN = 100
} STYLE_TRANSFER_STATUS;

class EXPORT StyleTransferWrapper { //public NNBaseFunctor
public:
    StyleTransferWrapper();
    ~StyleTransferWrapper() = default;
    
public:
    int init(std::vector<std::string> modelPath, std::string xnnConfig, std::string algoConfig) ;
    std::vector<StyleTransResult> run(Image input_image, const float roi[], const int rotation, const bool mirror);
    std::vector<StyleTransResult> run_multi_instance(Image input_image, const std::vector<FaceDetail> face_details, const int rotation, const bool mirror);
    std::vector<StyleTransResult> process_image(Image & input_image, const float* inputRoi, const int degree, const bool mirror);
    Image post_process(float *maskData,const unsigned char *inputBuffer, STSize maskSize, STFrame roi);
    void release();
 
    
private:
    void * _processor;          //算法引擎对象
    std::vector<std::string> _modelPaths;
    std::string _xNNConfig;
    std::string _algoConfig;
    int parseAlgoConfig(std::string json);
    int setDefaultAlgoParams();
    double now_sec();
    std::vector<int> _inputTensorSize;
    std::vector<int> _outputTensorSize;

    std::vector<Tensor> _inputTensors;
    std::vector<Tensor> _outputTensors;
    int _maxNumTarget; //最大处理目标数量

    // uitl funcs
    std::vector<float> get_dilated_bbox(const float H, const float W, const std::vector<float> faceRect, const float dilate_ratio);

};

#endif /* style_transfer_wrapper_hpp */
