#pragma once

#include <memory>
#include "selfrelated_posematcher.h"
#include "templatebased_posematcher.h"
#include "dynamic_posematcher.h"

class PoseMatcher {
public:
    PoseMatcher() = default;
    ~PoseMatcher() = default;

    bool init(std::string templateBasedFile, std::string xnn_config, 
                std::string selfRelatedFile, int fps);
    int match(float *kps, int nrof_kps, int index);
    void release();

private:
    std::shared_ptr<float> filter(float* raw_kps, int nrof_kps);

    std::shared_ptr<TemplateBasedPoseMatcher> templateBasedEngine_ = nullptr;
    std::shared_ptr<SelfRelatedPoseMatcher> selfRelatedEngine_ = nullptr;
    std::shared_ptr<DynamicPoseMatcher> dynamicEngine_ = nullptr;
};

