#pragma once

#include <string>
#include <vector>
#include <map>
#include <memory>

#include "defs.h"

class OCR;
class CacheUtils;

class EXPORT OCRWrapper {
public:
    OCRWrapper() = default;
    ~OCRWrapper() = default;

    void set_object_flag(int flag) {
        object_flag_ = flag;
    }

    void set_image_flag(int flag) {
        image_flag_ = flag;
    }

    Image get_object_image() {
        return object_image_;
    }

    Image get_roi_image() {
        return roi_image_;
    }

    int get_rec_flag();

    int init(std::vector<std::string> models, std::string algo_config, std::string xnn_config);
    Results run(Image& image, float roi[], int rotation, bool mirror);
    void release();

private:
    int object_flag_ = 0;
    int image_flag_ = 0;

    Image roi_image_;
    Image object_image_;
    std::shared_ptr<OCR> ocr_;
    CacheUtils* ocr_resultcaches;
    std::string ocr_modelmd5 = "";
};
