#pragma once
#include <string>
#include "xnn_utils.h"
#include "defs.h"

namespace xmedia{

typedef struct InstanceInfo
{
	int id;
	std::string label;
	float confidence;
	float rect[4]={0};
	float view[6] = {0};
	float * keypoints=nullptr;
	float * kpt_confs =nullptr;
} InstanceInfo;
typedef InstanceInfo * pInstanceInfo; 

class Keypoints
{
public:
	int init(std::vector<std::string>& models,std::string xnn_config, std::string algo_config);
    int detect(Image& image, float roi[], int rotation, bool mirror);
	int track_one(Image& image, pInstanceInfo & pInfo, int rotation, bool mirror);
	int get_6dof(Image& image, pInstanceInfo & pInfo, int rotation, bool mirror);
	void release();
	std::vector<pInstanceInfo> get_results();
	int get_kpt_num();
private:
	void parseAlgoConfig(std::string json);
	void expand_box_byfactor(const float * box, float * new_box, float factor,bool inframe , int width, int height);
	void reset_struct(pInstanceInfo pInfo);
	void compute_rect_by_keypoints(const float * kpts, float * box, int num);

private:
	std::shared_ptr<XnnUtils> detecter_;
	std::shared_ptr<XnnUtils> landmarker_;
	std::shared_ptr<XnnUtils> posenet_;
	Image det_image_;
	Image kpt_image_;
	Image pose_image_;
	int max_instance_num_;
	int kpt_num_;
	int kpt_stride_;
	float track_conf_;
	float det_conf_;
	float expand_factor_;
	pInstanceInfo pArray_;

};


}