#pragma once

#include "defs.h"
namespace ImageUtils {
    /*
    *
    */
    EXPORT int bytes_per_pixel(int PIX_FMT);
    /*
     *
     */
    EXPORT bool alloc(Image& image, int width, int height, int format);
    EXPORT bool realloc(Image& image, int width, int height, int format);

    /*
     *
     */
    EXPORT void recycle(Image& image);
    /*
     *
     */
    EXPORT bool convert(Image& dst, Image& src, float roi[], int rotation, bool mirror, unsigned char padding_value = 0);

    /*
     *
     */
    EXPORT bool convert_optimized(Image& dst, Image& src, float roi[], int rotation, bool mirror, unsigned char padding_value = 0);

    /*
     *
     */
    EXPORT bool fill(Image& dst, Image& src, int offset_x = 0, int offset_y = 0, unsigned char padding_value = 0);

    /*
     * ffplay -f rawvideo -pix_fmt bgr24 -video_size 1920x1080 a.bgr
     */
    EXPORT void save(const char* path, Image& image);
    EXPORT bool mirror(Image& image);

    EXPORT void GetRotation2D(float * aff, const float * roi , int width, int  height, int rot_ccw, bool keep_ratio=true);
    EXPORT void GetRotationBack2D(const float * aff, float * aff_back );
    EXPORT bool warpAffine(Image& dst, Image& src, float * affMat, unsigned char padding_value);
};
