#ifndef HUAMAN_POSE_DETECT_WRAPPER_H_
#define  HUAMAN_POSE_DETECT_WRAPPER_H_

#include <string>
#include "defs.h"

class HumanPoseDetect;
class HumanDetection;
class KptFilter;

struct HUMANST
{
	float * kpts;
	float * bbox;
};
typedef struct HUMANST HumanSt;
typedef struct HUMANST* pHumanSt; 

class EXPORT HumanPoseDetectWrapper
{
public:
	int init(std::vector<std::string> models, std::string algo_config, std::string xnn_config);
	std::vector<Results> run(Image& image, float roi[], int rotation, bool mirror);
	void release();

private:
	void get_out_humans_multi_(const float* pose_result);
	void get_out_humans_single_(const float * pose_result);
	void smooth_humans(Image&image, int rotation);
	int reid_by_pnts_box_(const pHumanSt human, const pHumanSt* last_humans, const int* is_matched, float & max_iou);
	void reid_n_reorder();
	void parseAlgoConfig(std::string json);
	int get_detect_result(Image&image, float * roi, int rotation, bool mirror);
	int get_pose_result(Image& image, float * roi, int rotation, bool mirror);
	int handle_miss_pnts(float thres);
	int check_union_bbox(float thres);
	int get_last_human_num();
	int check_upper_body(int min_num);
	void cal_output_area(Image& image, int rotation, float * rect);

private:
	Image pose_image_;
	Image det_image_;
	float det_rect_[4];
	float last_rect_[4];
	int det_times_;
	int do_track_;
	int human_num_;
	int max_person_num_;
	int wufu_;
	int test_cpu_rate_;
	bool multi_mode_;
	float person_conf_;
	float kp_conf_;
	float det_conf_;
	pHumanSt out_humans_;
	pHumanSt last_out_humans_;
	pHumanSt last_humans_;
	int * frames_cnt_;
	int * has_miss_pnt_;
	int * match_idx_;
	int * last_match_idx_;
	std::shared_ptr<HumanPoseDetect> human_pose_detect_;
	std::shared_ptr<HumanDetection> human_detection_;
	std::vector<std::string> labels_;
    std::vector<std::shared_ptr<KptFilter>> filters_;

};

#endif

