#pragma once
//extern "C" {
#include <string>
#include <vector>
#include <memory>
#include <cmath>       /* atan2 */
#include "defs.h"
#define MAX_HAND_NUM 2
#define HAND_KPT_NUM 21

struct HandSt 
{
	int handId=-1;
	float conf=0;
	int angle=361;
	float * box = nullptr; 
    float * kpts = nullptr;
    float * vis = nullptr;
};
typedef HandSt HandSt;
typedef HandSt * pHandSt;

class HandKpDet;
class Detect;

class HandOneEuroFilter;


class EXPORT HandKpDetWrapper {
public:
    int init(std::vector<std::string> models, std::string algo_config, std::string xnn_config);

    Results run(Image image, float roi[], int rotation, bool mirror);
    Results get_bbox();

    void release(); 

private:
    void parseAlgoConfig(std::string json);
    void compute_hand_bbox(const float* kpdet_result, float* box, Image& image);
    int detect(Image& image, float* roi, int rotation, bool mirror);
    void affine_back_rect(float* rect, float x1, float y1, float x2, float y2, const float* aff_back);
    int detect_kpt(Image& image, pHandSt face, int rotation);
    void expand_box_byfactor(const float * box, float * new_box, float factor, int width, int height);
    void clear_hand_struct(pHandSt hand);
    void reid_n_reorder(Image& image);
    int reid_by_pnts_box_(const pHandSt hand, const pHandSt * last_hands, const int* is_matched, float &max_iou);
    float iou_bbox(const float* bbox1, const float* bbox2);
    void smooth_hands(Image& image);

private:
    std::vector<double> conf_ = {0.7, 0.9};
    float bbox_extend_coef_ = 1.2f; // 检测框往外扩bbox_extend_coef倍ss
    float hand_conf_pre_ = -1.0f;    // hand conf of previous frame
    Image detect_image_;    // image for hand detect
    Image kpdet_image_;     // image for hand key point detection
    std::shared_ptr<HandKpDet> hand_kp_det_engine_;
    std::shared_ptr<Detect> detect_engine_;
    float rotation_pi = 3.1415926;

    int do_track_ = 0;
    pHandSt hands_;
    int maxHandNum_ = 1;
    float minimum_scale_ = 0.03;
    int framecnt_ = 0;
    int detect_interval_ = 10;
    std::vector<std::shared_ptr<HandOneEuroFilter>> filters_;
    std::vector<std::shared_ptr<HandOneEuroFilter>> box_filters_;

	pHandSt last_hands_;
	int * frames_cnt_;
    int * match_idx_;
    int hand_num_;
}; 

