#pragma once

#include <string>
#include <vector>
#include <memory>

#include "defs.h"

class Classify;
class Detect;

class EXPORT HandGestureDetectWrapper {
public:

    Image get_object_image() {
        return detect_image_;
    }

    Image get_roi_image() {
        return roi_image_;
    }

    int init(std::vector<std::string> models, std::string algo_config, std::string xnn_config);
    Results run(Image& image, float roi[], int rotation, bool mirror);
    void release();

private:
    void parseAlgoConfig(std::string json);

private:
    Image roi_image_;
    Image detect_image_;
    Image classify_image_;

    std::vector<double> conf_ = {0.2, 0.7};
    std::shared_ptr<Classify> classify_engine_;
    std::shared_ptr<Detect> detect_engine_;
};
