//
//  faceTrackInfo.h
//  XMedia
//
//  Created by tao zeng on 2020/10/21.
//  Copyright © 2020 Alipay. All rights reserved.
//

#ifndef faceTrackInfo_h
#define faceTrackInfo_h

#include "defs.h"

#define FACE_OUT_KEY_PT_NUM 51
#define METAFCE_KEY_PT_NUM 83

typedef enum FaceDetectTrackType
{
    FaceDetectTrackTypeDefault = -1,
    FaceDetectTrackTypeMouth = 0,
    FaceDetectTrackTypeEye
}FaceDetectTrackType;

typedef struct FaceParam
{
    FaceDetectTrackType detectType = FaceDetectTrackTypeDefault;
    int maxFaceNum = 1;
    bool fit3D = true;
    int mode = 1; //0 image mode; 1 video mode
    int highAccuracy = 0;// -1 : 51 points; 0 :98 points ; 1: 98 points higher accuracy but slower  , 2 : 198 points dense keypoints
    bool smooth = true;
    bool fitExpression = false;
}FaceParam;

struct FaceDetail
{
    int faceId;
    int faceTrackFrame;  // how many frames has the face been tracked
    std::vector<float> faceRect;//{x, y, w, h}
    std::vector<float> faceKeypointsNormalized;//{x1, y1, x2, y2, ....,x51, y51} 51 point normalized
    std::vector<float> faceKeypoints;// 51 points
    std::vector<float> faceKeypointsNormRaw;// 98 points
    std::vector<float> faceVis;

    Image faceCropImage;// size = nCropWidth*nCropHeigt*3
    int nCropCtrX;
    int nCropCtrY;

    std::vector<float> faceMatrix;//float[16]
    std::vector<float> faceAngle;//float[3] X,Y,Z anggle
    std::vector<float> faceKptsHeadNorm;// float[] {x1, y1, x2, y2} //have values when fit3d is True
    std::vector<float> metafaceKeypoints; //projected 2d metaface keypoints
    std::vector<float> faceTrans; // X,Y,Z tranlation
    std::vector<float> affMat_back; // reverse transformation of preprocess in metaface recontruction
    std::vector<float> metafaceShape3d; // original 3d landmarks of metaface reconstruction
    std::vector<float> expCoeff;
};
typedef FaceDetail FaceDetail;
using FaceDetails = std::vector<FaceDetail>;

//struct for blox
struct FaceResultInfo : ResultInfo {
    FaceDetails faceItems;
};

#endif /* faceInfo_h */
