#ifndef FACE_TRACK_ENGINE_WRAPPER_H_
#define FACE_TRACK_ENGINE_WRAPPER_H_
#include "defs.h"
#include <string>
#include <vector>
#include <iostream>
#include "face_track_info.h"

#define RELEASE_MEMORY(p) if(p) {delete []p; p=nullptr;}

namespace xmedia {
class CFit3DFaceEngine;
class CFitExpEngine;
}

struct FaceInfo
{
    int faceId = -1;
    int faceTrackFrame = -1;
    float * faceRect = nullptr;
    float * faceKptsNorm198 = nullptr;
    float * faceKptsNorm98 = nullptr;
    float * faceKptsNorm51 = nullptr;
    float * faceKpts51 = nullptr;
    float * faceVis = nullptr;
    int nCropWidth = 0;
    int nCropHeight = 0;
    int nCropCtrX = 0;
    int nCropCtrY = 0;
    unsigned char * faceCropData = nullptr;
    float * face_output_land = nullptr;
    float * faceMatrix = nullptr;
    float * faceAngle = nullptr;
    float * faceTrans = nullptr;
    float * affMat_back = nullptr;
    float * faceKptsProj = nullptr;
    float * faceshape3d = nullptr; //original 3d face shape before rotation&translation&projection
    float * expCoeff = nullptr;
    
};
typedef FaceInfo FaceInfo;
typedef FaceInfo *  pFaceInfo;

class FaceDetectAndLandmark;
class CFit3DFaceEngine;
class SmileCropUtility;

class EXPORT FaceTrackEngine
{
public:
    FaceTrackEngine();
    ~FaceTrackEngine() = default;

    void set_detect_params(FaceParam& param);
    int set_detect_interval(int interval);
    int init(std::vector<std::string>& models, std::string algo_config, std::string xnn_config);
    int init(std::vector<std::string>& models, std::string algo_config, std::vector<std::string> xnn_configs);
    int run(Image& image, float roi[], int rotation, bool mirror);
    int track(Image& image, float roi[], int rotation, bool mirror);
    int fit3d(Image& image, float roi[], int rotation, bool mirror, std::vector<float>& keypoints);

    Results detect(Image& image, float roi[], int rotation, bool mirror);
    int track(Image& image, Results& dets, int rotation, bool mirror);
    bool request_detect();

    int simulate_run(Image& image, float roi[], int rotation, bool mirror);

    FaceDetails getFaceArray();
    int getStatus(); // -1: error, 0: detect, 1: track
    void release();
private:
    int forward(Image& image, float roi[], int rotation, bool mirror);
    int init_faceTrackCls(std::vector<std::string>& models, std::string algo_config, std::vector<std::string> xnn_configs);
    int fit_face(Image& image, float roi[], int rotation, bool mirror, pFaceInfo& face);
    void fill_box_landmarks(Image& image);
    void parseAlgoConfig(std::string json);
    void normalize_keypoints(pFaceInfo pface, Image& image);
    void merge_to_high_accuracy(pFaceInfo pface, void* pfst, Image& image);
    void convert_to_format_51(float * dst,  float * src , int sized, int sizes);
    float lagrange_interpolation(float * result, float * xy, int num, float x);
    void calc_face_box(const float * kpts, float * box, int num);

private:
    FaceDetectTrackType detectType_;
    int maxFaceNum_;
    bool fit3D_;
    bool fitExpression_;
    int mode_;
    int highAccuracy_;
    bool smooth_;
    int nkpt_;
    int num3d_;
    int det_frame_;
    int n_blendshape_;
    int enable_face_detection_;
    int enable_face_landmark_;
    std::string eng3dName_;
    pFaceInfo faceArray_;
	FaceDetectAndLandmark* pFaceTrackCls;
	xmedia::CFit3DFaceEngine * pFit3DFaceEng;
    xmedia::CFitExpEngine * pFitExpEng;
    SmileCropUtility * pSmileCropUtil;

};

#endif
