#pragma once
#include <string>
#include <vector>
#include "defs.h"
#include "face_track_info.h"
#include <map>

namespace xmedia{
	class FaceAttribute;
}
class EXPORT FaceAttributeWrapper
{
public:
	/*param@models: model path list by sequence: openeye, openmouth, smile. can be less than three*/
	int init(std::vector<std::string> models, std::string algo_config, std::string xnn_config);
	/*param@attributes:if empty, detect all supported attributes*/
    Results detect(Image image, FaceDetail & face_detail, std::string attributes, int rotation, bool mirror);
	void release();

private:
	void parseAlgoConfig(std::string json);
	std::vector<std::string>split_string(const std::string& str, const std::string & delim);

private:
	std::shared_ptr<xmedia::FaceAttribute> attr_engine_;
	std::map<std::string, int> name2model_;
	std::map<std::string, float> thres_;

};

/*sample code:
	FaceAttributeWrapper faw;
	vector<string> models = {openeye.xnn, openmout.xnn, smile.xnn;
	string algo_config = {\"eyeopen_conf\":0.8,\"mouthopen_conf\":0.7,\"smile_conf\":0.9};
	string xnn_config = "common:xnnnextgen=1,cpu_num=2,graysw=1";
	faw.init(models, algo_config, xnn_config);	
	results = faw.detect(image, face_detail, "eyeopen|smile|mouthopen", rotation, mirror);
	faw.release();
*/
