#ifndef Corner_WRAPPER_H_
#define  Corner_WRAPPER_H_

#include <stdio.h>
#include <string>
#include <vector>
#include <memory>

#include "tensor_process_wrapper.h"
#include "tensor_utils.h"
///
/// strength 是bling点密度，范围为[0-1]。0为没有，1为最密。初始化默认为1. 后续可以用setoption改变数量。
/// 为方便跟踪，返回值为size固定为100的results。每个点在array中固定位置。
/// 每个result中，如果检测到角点，则pos为size=2的vector。conf为强度。如果没有检测到，pos的size=0.conf=0
///
class EXPORT CornerDetectionWrapper
{
public:
    CornerDetectionWrapper();
    ~CornerDetectionWrapper() = default;
    int init();
	Results run(Image& image, int rotation, bool mirror);
	void set_strength(float strength);
	void release();
private:
    bool preprocess(Image& image, int rotation, bool mirror);
	Results postprocess(float* output, int height, int width);
	Results cpu_run(Image& image);
	void sobel(unsigned char * frame, int height, int width, float * result);
private:
	//算法引擎对象
	Image gray_image_;
	std::vector<std::vector<int>> last_points;
	int _bling_count; //最大点数目
	float _strength;
};

#endif

