#pragma once

#include <string>
#include <vector>
#include "defs.h"

namespace xmedia{
	class Keypoints;
}
class EXPORT CommonKeypointsWrapper
{
public:
	int init(std::vector<std::string> models, std::string algo_config, std::string xnn_config);
    std::vector<Results> run(Image image, float roi[], int rotation, bool mirror);
	void release();
	std::vector<std::vector<float>> get_object_angles();

private:
	void parseAlgoConfig(std::string json);
    std::vector<Results> detect(Image image, float roi[], int rotation, bool mirror);
    std::vector<Results> track_one_object(Image image, float roi[], int rotation, bool mirror);

private:
	std::shared_ptr<xmedia::Keypoints> kpt_engine_;
	int do_track_;
	int mode_;
	int det_nothing_num_;
	int interval_;

};

