//
//  XMediaTensor.h
//  XMedia
//
//  Created by haoxing on 2020/3/19.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

extern NSString *const kTensorName;
extern NSString *const kTensorShape;
extern NSString *const kTensorType;
extern NSString *const kTensorData;
extern NSString *const kTensorExtraData;

extern NSString *const kTensorSource;
extern NSString *const kTensorOptions;

extern NSString *const kTensorBase64;
extern NSString *const kTensorWidth;
extern NSString *const kTensorHeight;
extern NSString *const kTensorFormat;
extern NSString *const kTensorStride;

extern NSString *const kTensorConvert;
extern NSString *const kTensorRotation;
extern NSString *const kTensorMirror;
extern NSString *const kTensorCrop;
extern NSString *const kTensorPad;
extern NSString *const kTensorPadValue;
extern NSString *const kTensorFlip;
extern NSString *const kTensorResize;

@interface XMediaTensor : NSObject

@property (nonatomic, strong) NSString *name;
@property (nonatomic, strong) NSArray  *shape;
@property (nonatomic, strong) NSString *type;            //跟xNN tensor type对齐  -->string
@property (nonatomic, strong) id data;                   //type决定
//处理设置参数，当用户不对数据源调用XMediaTensorProcessor接口进行处理，直接在tensor里面描述好处理参数，modelProcessor对象就直接对输入tensor中的data进行actionParams指定的处理后再做infer处理
//@property (nonatomic, strong) NSArray *actions;

@property (nonatomic, strong) NSDictionary *jsonResult;

@end

NS_ASSUME_NONNULL_END
