//
//  XMediaSTAFunctor.h
//  XMedia
//
//  Created by tao zeng on 2020/7/23.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import "XMediaBaseFunctor.h"

NS_ASSUME_NONNULL_BEGIN
@class XMediaSTAResult;

@interface XMediaSTAFunctor : XMediaBaseFunctor

/**
 *   XMediaSTAFunctorr初始化
 *
 *  @param bizId 业务标识
 *  @param resourcePath 动画包资源路径
 *  @param options 扩展字段
*/
- (instancetype)initWithBizId:(NSString *)bizId
                    resourcePath:(NSString *)modelPath
                      options:(NSDictionary *)options;

/**
 *  图片处理接口
 *
 *  @param audioPath 音频文件地址
 *  @param state 当前状态：IDLE=0；LISTEN=1,ANSWER=2
 *
 *  @return 返回结果
 */
- (XMediaSTAResult *)processWithAudioFile:(NSString *)audioPath
                           state:(int)state;

/**
 *  图片处理接口
 *
 *  @param audioPath 音频文件地址
 *  @param mode 当前模式：MODE_NOTANSWER=0；MODE_ANSWER=1,MODE_CONFIGURATION=2
 *  @param rule 当前规则：RULE_SELECT=0；RULE_CONFIGURATION=1
 *  @param animationSet：int 数组
 *
 *  @return 返回结果
 */
- (XMediaSTAResult *)processWithAudioFile:(NSString *)audioPath
                                     mode:(int)mode
                                     rule:(int)rule
                             animationSet:(NSArray*)aniSet;

@end

NS_ASSUME_NONNULL_END
