//
//  XMediaNNSourceProcessor.h
//  XMedia
//
//  Created by haoxing on 2020/6/25.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

@class XMediaTensor;
@interface XMediaNNSourceProcessor : NSObject

/**
 *  输入图像数据转成tensor
 *
 *  @param Image       输入源
 *
 *  @param options     tensorOptions
    source.options: 数据源处理参数 : Crop -> Resize -> Convert -> Rotate -> Mirror -> Pad
 [
     { crop : [0.0, 0.0, 1.0, 1.0] },  // 左上/右下,
     { resize: [224, 224] },           // [width, height],
     { convert : "BGR" },              // "BGR", "RGB", "GRAY"
     { rotate : 90 },                  // 0, 90, 180, 270
     { mirror : 0 or 1 },              // 镜像
     { flip : 0 or 1 },                // 上下颠倒
     { pad : [left, top, right, bottom] },
     { padValue : 0}
 ]
 *  @return 返回结果     tensor(name, shape, type, data)
*/
+ (XMediaTensor *)xMediaTensorFromImage:(UIImage *)uiImage roi:(CGRect)roi tensorOptions:(NSArray *)options;

/**
 *  输入arrayBuffer数据转成tensor
 *
 *  @param data       arrayBuffer data
 *  @param width       图像width
 *  @param height       图像height
 *  @param format       图像格式
 *
 *  @param options     tensorOptions
    source.options: 数据源处理参数 : Crop -> Resize -> Convert -> Rotate -> Mirror -> Pad
 [
     { crop : [0.0, 0.0, 1.0, 1.0] },  // 左上/右下,
     { resize: [224, 224] },           // [width, height],
     { convert : "BGR" },              // "BGR", "RGB", "GRAY"
     { rotate : 90 },                  // 0, 90, 180, 270
     { mirror : 0 or 1 },              // 镜像
     { flip : 0 or 1 },                // 上下颠倒
     { pad : [left, top, right, bottom] },
     { padValue : 0}
 ]
 *  @return 返回结果     tensor(name, shape, type, data)
*/
+ (XMediaTensor *)xMediaTensorFromArrayBuffer:(NSData *)data width:(int)width height:(int)height imageFormat:(int)format tensorOptions:(NSArray *)options;

/**
 *  输入视频帧转成tensor
 *
 *  @param pixelBuffer       视频帧
 *  @param camOrientation       相机方向
 *  @param mirror                   是否镜像
 *  @param options     扩展字段
 *  @return 返回结果     tensor(name, shape, type, data)
*/
+ (XMediaTensor *)xMediaTensorFromPixelBuffer:(CVPixelBufferRef)pixelBuffer cameraOrientation:(AVCaptureVideoOrientation)camOrientation mirror:(BOOL)mirror options:(NSDictionary *)options;

@end
