//
//  XMediaKeyFrameResult.h
//  XMedia
//
//  Created by tao zeng on 2021/2/19.
//  Copyright © 2021 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XMediaResult.h"

//关键帧信息【关键帧图片+关键帧标签信息】
@interface XMediaKeyFrameItem : NSObject

@property (nonatomic, strong) UIImage *keyFrame;
@property (nonatomic, strong) NSDictionary *keyFrameInfo;

@end

//内容理解结果
@interface XMediaKeyFrameResult : XMediaResult

@property (nonatomic, strong) NSArray<XMediaKeyFrameItem *> *keyFrameItems; //关键帧信息列表
@property (nonatomic, strong) NSDictionary *videoInfo;   //视频标签信息列表

- (NSDictionary *)keyFrameInfoSerialize;    //关键帧信息(不含图片)序列化，跟Android格式保持一致

@end
