//
//  XMediaKeyFrameFunctor.h
//  XMedia
//
//  Created by tao zeng on 2021/2/8.
//  Copyright © 2021 Alipay. All rights reserved.
//

#import "XMediaBaseFunctor.h"

NS_ASSUME_NONNULL_BEGIN
@class XMediaKeyFrameResult;
@class XMediaKeyFrameConfig;
@class XMediaKeyFrame;

@interface XMediaKeyFrameFunctor : XMediaBaseFunctor

/**
 *  XMediaKeyFrameFunctor初始化
 *
 *  @param bizId 业务标识
 *  @param modelId 模型文件id
 *  @param modelPaths 关键字信息提取模型路径
 *  @param config 关键帧抽帧算法配置
 *  @param options 扩展参数
 */
- (instancetype)initWithBizId:(NSString *)bizId
                      modelId:(NSString *)modelId
                    modelPaths:(NSArray *)modelPath
               keyFrameConfig:(XMediaKeyFrameConfig *)config
                      options:(NSDictionary *)options;

/**
 *  关键帧处理接口
 *
 *  @param keyFrame 图片
 *  @param finalFrame 是否最后一帧
 *  @param options 关键帧检测阈值
 *  @return resultBlock 结果回调
 */
- (void)processWithImage:(XMediaKeyFrame *)keyFrame
            isFinalFrame:(BOOL)finalFrame
                options:(NSDictionary *)options
            resultBlock:(void (^)(XMediaKeyFrameResult *result))resultBlock;

@end

NS_ASSUME_NONNULL_END
