//
//  XMediaImageStaticFilter.h
//  XMedia
//
//  Created by haoxing on 2020/5/26.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface XMediaImageStaticFilter : NSObject

@property (nonatomic, assign, readonly) BOOL isBusy;        //算法处理中

/**
*  视频帧静止检测初始化接口
*
*  @param options  扩展字段，用于传静止算法参数配置，可不传。例如@{@"stillNum":@(6),@"initDelaySecond":@(0.2),@"minIntervalSecond":@(0.03),@"minStillSecond":@(0.2)}
*
*  参数默认值：
*  int stillNum = 6;
*  float initDelaySecond = 0.2;
*  float minIntervalSecond = 0.03;
*  float minStillSecond = 0.2;
*/
- (instancetype)initWithOptions:(NSDictionary *)options;

/**
*  视频帧静止检测判断接口
*
*  @param pixelBuffer   视频帧,支持BGRA和YUV
*  @param options       扩展字段，用于传静止算法参数配置，可不传
*
*  @return              静止检测结果
*/
- (BOOL)runWithPixelBuffer:(CVPixelBufferRef)pixelBuffer
                   options:(NSDictionary *)options;

@end

NS_ASSUME_NONNULL_END
