//
//  XMediaImageDecodeFunctor.h
//  XMedia
//
//  Created by tao zeng on 2021/3/3.
//  Copyright © 2021 Alipay. All rights reserved.
//

#import "XMediaBaseFunctor.h"

NS_ASSUME_NONNULL_BEGIN

@interface XMediaImageDecodeFunctor : XMediaBaseFunctor
/**
 *  创建实例之前先调用当前机型是否支持此功能接口，isSupported(继承基类的类方法)
 */

/**
 *  XMediaCommonNNFunctor初始化
 *
 *  @param bizId 业务标识
 *  @param modelId 模型文件id
 *  @param modelPath 模型路径数组
 *  @param options 扩展字段,@{kXMediaRemoteLogSampling:@(0)}
 */
- (instancetype)initWithBizId:(NSString *)bizId
                      modelId:(NSString *)modelId
                    modelPath:(NSString *)modelPath
                      options:(NSDictionary *)options;

/**
 *  图片解码接口
 *
 *  @param data 需要解码的图片数据
 *  @return 返回解码后的图片对象
 */
- (UIImage *)processWithData:(NSData *)data;

@end

NS_ASSUME_NONNULL_END
