//
//  XMediaHandKeyPointFunctor.h
//  XMedia
//
//  Created by tao zeng on 2019/9/20.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <XMedia/XMedia.h>


@interface XMediaHandKeyPointFunctor : XMediaBaseFunctor

- (instancetype)initWithBizId:(NSString *)bizId
                      modelId:(NSString *)modelId
               modelPathArray:(NSArray *)modelPathArray
                      options:(NSDictionary *)options;

/**
 *  手势检测
 *
 *  @param pixelBuffer 输入视频帧数据
 *  @param frontCamera 输入是否前置相机视频源
 *  @param options 扩展参数
 *
 *  @return 返回手势识别结果
 */
- (XMediaDetectResult *)gestureDetect:(CVPixelBufferRef)pixelBuffer
                    cameraOrientation:(AVCaptureVideoOrientation)cameraOrientation
                        isFrontCamera:(BOOL)frontCamera
                              options:(NSDictionary *)options;

/**
 *  手势打分
 *
 *  @param detectResult 手势检测结果
 *  @param gestureId 所参考手势在id
 *
 *  @return 返回结果匹配分数[0,1]
 */
- (float)gestureScore:(XMediaDetectResult *)detectResult gestureId:(NSString *)gestureId;

@end

