//
//  XMediaFaceTrackFunctor.h
//  XMedia
//
//  Created by tao zeng on 2020/10/13.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import "XMediaBaseFunctor.h"

NS_ASSUME_NONNULL_BEGIN

@class XMediaFaceResult;
@interface XMediaFaceTrackFunctor : XMediaBaseFunctor

/**
 *  创建实例之前先调用当前机型是否支持此功能接口，isSupported(继承基类的类方法)
 */

/**
 *  XMediaFaceTrackFunctor初始化
 *
 *  @param bizId 业务标识
 *  @param modelId 模型文件id
 *  @param modelPaths 模型路径列表
 *  @param options 扩展字段 e.g {kXMediaFaceDetectType:@(FaceDetectTypeDefault),kXMediaFaceDetectMaxNum:@(3),kXMediaFaceDetectFix3D:@(true)}
 */
- (instancetype)initWithBizId:(NSString *)bizId
                      modelId:(NSString *)modelId
                   modelPaths:(NSArray *)modelPaths
                      options:(NSDictionary *)options;

/**
 *  对相机帧进行人脸检测/跟踪
 *  @param options 扩展字段
 *
 *  @return 人脸检测的结果
 */
- (XMediaFaceResult *)processWithVideoFrame:(CVPixelBufferRef)cameraFrame
                 cameraOrientation:(AVCaptureVideoOrientation)cameraOrientation
                            mirror:(BOOL)mirror
                           options:(NSDictionary *)options;

/**
 *  对输入图片中的内容进行人脸检测
 *
 *  @param image   输入图片
 *  @param options 扩展字段
 *
 *  @return 人脸检测的结果
 */
- (XMediaFaceResult *)processWithImage:(UIImage *)image options:(NSDictionary *)options;

@end

NS_ASSUME_NONNULL_END
