//
//  FalconFaceItem.h
//  FalconARKitBiz
//
//  Created by taoyuan on 2017/11/2.
//  Copyright © 2017年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AVFoundation/AVFoundation.h>

@interface XMediaFaceItem : NSObject

@property (nonatomic, assign) NSUInteger trackId;               //跟踪
@property (nonatomic, strong) NSData *facePose;                 //16*sizeof(float)
@property (nonatomic, assign) CGRect faceRect;
@property (nonatomic, strong) NSArray *rotAngle;                //rotAngle[0~2]: face rotation angle along X/Y/Z axis
@property (nonatomic, strong) NSArray *faceKeyPoints;           //51个关键点(非归一化)
@property (nonatomic, strong) NSArray *faceKeyPointsNormalized; //51个关键点(归一化)
@property (nonatomic, strong) NSArray *faceKeyPointsNormRaw;    //98个关键点(归一化)
@property (nonatomic, strong) NSArray *faceKeyPointsHeadNorm;   //发际线13个点(归一化)
@property (nonatomic, strong) NSArray *facePointsVisibility;    //98个人脸关键点可见度值(0~1)

@property (nonatomic, strong) NSData *objectData;               //识别目标数据：比如人脸图
@property (nonatomic, assign) CGSize objectSize;                //识别目标size
@property (nonatomic, assign) CGPoint objectCenterPoint;        //识别目标中心点坐标
@property (nonatomic, strong) NSArray *faceExpressionPoints;    //表情数据

- (NSDictionary *)serialize;

@end
