//
//  XMediaDataFunctor.h
//  XMedia
//
//  Created by tao zeng on 2019/7/2.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import "XMediaBaseFunctor.h"

@class XMediaPredictResult;
@interface XMediaDataFunctor : XMediaBaseFunctor

/**
 *  创建实例之前先调用当前机型是否支持此功能接口，isSupported(继承基类的类方法)
 */

/**
*  XMediaPredictFunctor初始化
*
*  @param bizId 业务标识
*  @param modelId 模型文件id
*  @param modelPath 模型路径
*  @param options 扩展字段
*/
- (instancetype)initWithBizId:(NSString *)bizId
                      modelId:(NSString *)modelId
                    modelPath:(NSString *)modelPath
                      options:(NSDictionary *)options;

/**
 *  XMediaPredictFunctor初始化
 *
 *  @param bizId 业务标识
 *  @param modelId 模型文件id
 *  @param modelPath 模型路径
 *  @param patchPath patch路径
 *  @param options 扩展字段
 */
- (instancetype)initWithBizId:(NSString *)bizId
                      modelId:(NSString *)modelId
                    modelPath:(NSString *)modelPath
                    patchPath:(NSString *)patchPath
                      options:(NSDictionary *)options;
/**
 *  通用数据处理接口
 *
 *  @param dict 处理数据
 *
 *  @return 返回结果
 */
- (XMediaPredictResult *)processWithData:(NSDictionary *)dict;

/**
*  通用数据清理状态接口
*/
- (void)clearStatus;

@end

