//
//  XMediaCVFunctor.h
//  XMedia
//
//  Created by tao zeng on 2019/1/26.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import "XMediaBaseFunctor.h"
#include <libCVEngine/PoseData.h>
#include <libCVEngine/trackAPI.h>

@interface XMediaCVFunctor : XMediaBaseFunctor

/**
 *  创建实例之前先调用当前机型是否支持此功能接口，isSupported(继承基类的类方法)
 */

/***************************************************************
 *
 * Api for track2D.
 *
 **************************************************************/

/**
 *  跟踪系统初始化
 *
 *  @param modelPath 模型文件路径
 *  @param phyCam 物理相机参数
 *  @param virtualCam 虚拟相机参数
 *  @param width 追踪图片的宽度
 *  @param height 追踪图片的高度
 */
- (int)trackSystemInitWithModelPath:(NSString *)modelPath
                       phyCam:(const sPhyCamParaIOS)phyCam
                   virtualCam:(const sVirtualCamParaIOS)virtualCam
                        width:(int)width
                       height:(int)height;

/**
 *  图像跟踪
 *
 *  @param grayBuffer   追踪图片的Y通道首地址
 *  @param width        追踪图片的宽,需与初始化一致
 *  @param height       追踪图片的高,需与初始化一致
 *  @param step         追踪图片每行的pitch
 *
 *  @return 追踪结果.
 *   TrackResult.trackOK : 追踪结果
 *   TrackResult.pose : 4*4 矩阵,表示相机到图像的RT变换, 在trackOK为true时有意义
 */
- (TrackResult)trackWithImageBuffer:(uint8_t *)grayBuffer
                    width:(int)width
                   height:(int)height
                     step:(int)step;

/**
 *  跟踪系统资源释放
 *
 *  @return 0 注销成功
 */
- (int)trackSystemRelease;

/***************************************************************
 *
 * Api for Vision APIs using opencv.
 *
 **************************************************************/

/**
 *  SSIM 算法接口
 *
 *  @param preFrameBuffer 前一帧数据(BGRA format)
 *  @param curFrameBuffer 当前帧数据(BGRA format)
 *  @param width 帧宽度
 *  @param height 帧高度
 *
 *  @return 结果：< 0.0 mean invalid
                 >= 0.0 mean success
 */
- (double)ssimWithPreFrame:(uint8_t *)preFrameBuffer
            curFrameBuffer:(uint8_t *)curFrameBuffer
                     width:(int)width
                    height:(int)height;

/**
 *  darkhorse 算法接口
 *
 *  @param preFrameBuffer 前一帧数据(BGRA format)
 *  @param curFrameBuffer 当前帧数据(BGRA format)
 *  @param width 帧宽度
 *  @param height 帧高度
 *
 *  @return 结果：NULL mean invalid,if not NULL, return value is double[3x3] array
 */
- (double *)darkHorseWithPreFrame:(uint8_t *)preFrameBuffer
                   curFrameBuffer:(uint8_t *)curFrameBuffer
                            width:(int)width
                           height:(int)height;
@end

