#include<iostream>
#include <vector>

class KeyFrameExtractor {
public:
    KeyFrameExtractor()=default;
    ~KeyFrameExtractor();
    int init(float threshold, int histSize, int * ranges, int gap, int maxKeyNum, float summaryLength);
    void processVideoByFrameNew(unsigned char * frame, int height, int width);
    void processVideoByFrame(unsigned char* frame, int height, int width, double timeStamp, bool isFinish, bool hasChacter);
    std::vector<unsigned char *> _keyFrames, _keyFramesFilter;
    std::vector<float> _athetics;
    std::vector<double> _timeStamps;

 private:
    void calHistDistance(float * hist1, float * hist2, int histSize, float & dist);
    void calGradient(unsigned char * frame, int height, int width, int * & frameXY);
    void calHistgoramRGB(unsigned char * frame, int height, int width, float * & hist);
    void calAesthetics(unsigned char * frame,  int height, int width, float & score);
    bool shotBoundaryDetect(unsigned char * preFrame, unsigned char * curFrame,  unsigned char * yPreFrame, unsigned char * yCurFrame, int height, int width, float &dist);
    void calEdge(unsigned char * frame, int height, int width, unsigned char *& edge);
    void gaussianBlur(unsigned char * frame, int height, int width, float * kernel, int raduis, unsigned char * blurxy);
    int findEdgeIndex(int k, int j, int width);
    float mask(unsigned char * preFrame, unsigned char * curFrame, int height, int width);
    void keyFrameFilter(std::vector<unsigned char *> frames, std::vector<unsigned char *> &framesFilter);
    void sampleImageRGBA(unsigned char * frame, int height, int width, int gap, unsigned char * & frameSample);
    void convertRGB2YUV(unsigned char * rgb, int height, int width, unsigned char * y);
    void calMean(unsigned char * frame, int height, int width, float & mean);
    void calVariance(unsigned char * frame, int height, int width, float & var);
    int ranges[2];
    float threshold;
    int histSize;
    int indexAesthetics;
    int gap;
    int maxKeyNum;
    float summaryLength;
    int height, width, heightSample, widthSample;
    int length, lengthSample;
    unsigned char * _preFrame, * _curFrame, * _keyFrame;
    float preAesthetic, curAesthetics;
    double preTimeStamp;
    
};
