#ifndef FACE_ONE_EURO_FILTER
#define FACE_ONE_EURO_FILTER

#include "defs.h"

class EXPORT FaceOneEuroFilter
{
public:
	FaceOneEuroFilter();
    ~FaceOneEuroFilter();
    void release();
    void reset(float min_cutoff, float d_cutoff, float beta,float t0, int size);
    void reset(float min_cutoff, float d_cutoff, float beta,float t0, int size, float pitch_coef, float yaw_coef);
    void clear();
    void filter(float * x, float len, float t=0.03, float *euler=nullptr);
    void filter_adaptive(float * x, float len, float angle[], float t=0.03);
    void filter(float ** xs, int * nums, int len, float norm, float t=0.03, float * euler=nullptr);
    float smoothing_factor(float t_e, float cutoff);
    float exponential_smoothing(float a, float x, float x_pre);
	void angle_ware(float * euler, float& a);
    void angle_ware(float * euler, float& a, float yaw_coef, float pitch_coef, float yawl_angle, float pitch_angle);
	
private:
    float min_cutoff_;
    float d_cutoff_;
    float beta_;
    float t_pre_;
    int size_;
    float * x_pre_;
    float * dx_pre_;
    float pitch_coef_;
    float yaw_coef_;
};



#endif
