//
//  APLogSpmContext.h
//  APRemoteLogging
//
//  Created by majie on 16/8/3.
//  Copyright © 2016年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

#pragma mark - APLogManualPageInfo
@class SPMNewChinfoItem;
@class SPMParams4ExtesionItem;
@class SPMOpenIdItem;
@class SPMPageStartItem;

//重构手动spm埋点，解决ios8以下，生命周期的问题
@interface APLogManualPageInfo : NSObject<NSCopying>

@property (atomic, weak) NSObject *weakIndex;

//当前页面流水号
@property (atomic, strong) NSString *pageId;
//页面seq
@property (atomic, strong) NSString *pageSeq;

//当前页面spmid
@property (atomic, strong) NSString *pageSpmId;

//打开时间
@property (atomic, strong) NSNumber *t1;
//打开时间
@property (atomic, strong) NSNumber *t0;//用CACurrentMediaTime 计算
@property (atomic, strong) NSString *stayTime;

//页面打开时间
@property (atomic, strong) NSString *startTime;

//应用appid
@property (atomic, strong) NSString *appId;

//是否已经调用过pageEnd
@property (atomic, assign) BOOL didEnd;
// 来源cell的spm，没有兜底，不许求改
@property (atomic, copy) NSString *referSpm;
// 来源cell的spm，允许修改，优先使用上个页面的lastSPM兜底，其次上个页面的pageSpmId兜底
@property(atomic, strong) NSString *srcSPM;
// 当前页面最后点击的SPM
@property(atomic, strong) NSString *lastSPM;
// refer的PageInfo
@property(atomic, strong) APLogManualPageInfo *referPageInfo;
// 页面重复（锁屏、进后台）埋的点
@property(atomic)  BOOL isPageRepeat;
// 页面回退 单步
@property(atomic)  BOOL isBack;
// 多步回退
@property(atomic) BOOL isMultistepBack;
// tab切换
@property(atomic) BOOL isTabSwitch;
// refer2 前两步的页面
@property(atomic, copy) NSString *refer;
@property(atomic, copy) NSString *refer2;
@property(atomic, strong) SPMNewChinfoItem *chinfoItem;
@property(atomic, strong) SPMParams4ExtesionItem *extesionItem;
@property(atomic, strong) SPMOpenIdItem *openIdItem;
// 页面类型
@property(atomic, assign) SPMPageType pageType;
// pageRefer
@property(atomic, strong) NSString *framePageSrc;
@property(atomic, strong) NSString *framePageRefer;
@property(atomic, strong) NSString *bizPageSrc;
@property(atomic, strong) NSString *bizPageRefer;
@property(atomic, strong) NSString *autoPageSrc;
@property(atomic, strong) NSString *bizClickSrc;
@property(atomic, strong) NSString *frameClickSrc;
@property(atomic, strong) NSString *autoClickSrc;
@property(atomic, strong) NSString *bizClickRefer;
@property(atomic, strong) NSString *frameClickRefer;
@property(atomic, strong) NSString *bizClickSeqSrc;
@property(atomic, strong) NSString *frameClickSeqSrc;
@property(atomic, strong) NSString *autoClickSeqSrc;
@property(atomic, strong) NSString *bizLastClick;

@property(atomic, strong) NSString *pageScm;
@property(atomic, assign) BOOL isFirst;
@property(atomic, assign) BOOL isFromUep;

@property(atomic, strong) NSString *bizCode;
@property(atomic, strong) NSString *chinfo;

+ (void)filterPageInfo:(APLogManualPageInfo *)pageInfo;
+ (APLogManualPageInfo *)createPageInfoWithSpmId:(NSString *)spmid index:(NSObject *)index pageType:(SPMPageType) pageType scm:(nullable NSString *) scm pageSeq:(nullable NSString *)pageSeq ignoreConect:(BOOL)ignoreConect;
+ (void)updatePageId:(APLogManualPageInfo *)pageInfo WithSpmid:(NSString *)spmid pageSeq:(NSString *)pageSeq;

@end

#pragma mark - APLogManualPageInfo 全引导
@class SPMFullGuideItem;

extern const NSUInteger kAPLogManualPageInfo_Min_TraceStep;       //最小全引导步数
extern const NSUInteger kAPLogManualPageInfo_Max_TraceStep;       //最大全引导步数
extern const NSUInteger kAPLogManualPageInfo_Default_TraceStep;   //默认全引导步数

@interface APLogManualPageInfo (/*全引导*/)

// 全引导参数 【数组Item： 0： p-root 1： p-pre 2: p-pre2 ...】
@property (nonatomic, strong) NSMutableArray *pageParamsArray;
// 是否在透传全引导
@property (atomic, assign) BOOL isTracking;

//设置全引导参数
- (void)setPageParams:(NSString *)pageParams traceStep:(NSUInteger)step;
//透传全引导参数
- (void)passPageParamsToPageInfo:(APLogManualPageInfo *)pageInfo;
//p-proot Item
- (nullable SPMFullGuideItem *)pRootItem;
//全引导字典
- (nullable NSDictionary *)fullGideDict;

- (SPMFullGuideItem *)fullGuideItemAtIndex:(NSUInteger)index;

@end

@interface APLogManualPageInfo (/*全引导*/)

@property (nonatomic, strong)NSMutableArray <SPMPageStartItem *>* pageStartList;
- (void)updateFirstStartItemStayTime:(NSString *)pageStayTime;

@end

#pragma mark - APLogManualContext

@interface APLogManualContext : NSObject

+ (instancetype)sharedInstance;

//上一个页面的spmid
@property (atomic, strong) NSString *lastPageSpmId;

//上一个页面流水号
@property (atomic, strong) NSString *lastPageId;

//上一个页面
@property (atomic, strong) NSString *lastViewId;

//上一个页面的pageInfo，包含srcSPM、lastSPM、pageId等
@property (atomic, strong) APLogManualPageInfo *lastPageInfo;

- (APLogManualPageInfo *)pageInfoForKey:(NSString *)key;
- (void)removePageInfoForKey:(NSString *)key;
- (void)updatePageInfo:(APLogManualPageInfo *)pageInfo withSpmId:(NSString *)spmId scm:(nullable NSString *)scm;
- (void)updatePageInfo:(NSObject *)index withSrcSpm:(NSString *)srcSpm;
- (void)updatePageInfo:(APLogManualPageInfo *)pageInfo withLastSpm:(NSString *)lastSpm;
- (void)insertPageInfo:(APLogManualPageInfo *)pageInfo forKey:(NSString *)key;
- (void)checkWeakPageInfo;
- (NSString *)getSrcSpmFromDict:(NSObject *)index;
- (void)destroyPageInfoWithIndex:(NSObject *)index;

//为了判断圣火令的pageInfos
- (APLogManualPageInfo *)gPathPageInfoForKey:(NSString *)key;
- (void)removeGpathPageInfoForKey:(NSString *)key;
- (void)insertGpathPageInfo:(APLogManualPageInfo *)pageInfo forKey:(NSString *)key;

- (void)setUepKey:(NSString *)key withManulHashCode:(NSString *)hashCode;
- (void)setManualKey:(NSString *)key withUepHashCode:(NSString *)hashCode;
- (NSString *)manualHashCodeForUepKey:(NSString *)key;
- (NSString *)uepHashCodeForManulKey:(NSString *)key;
- (void)addPageItemWithSpmId:(NSString *)spmId key:(NSString *)key isUep:(BOOL) isUep ;
- (NSString *)pageIdForItemKey:(NSString *)key isUep:(BOOL) isUep;
- (NSString *)pageSeqForItemKey:(NSString *)key isUep:(BOOL) isUep;
- (void)setupPageSwitchSetWithArray:(NSArray *)array;

#pragma mark - Next Page Params

//删除下一个页面的参数
- (void)clearNextPageParams:(BOOL) isForce;
// get
- (nullable SPMFullGuideItem *)getNextPageItem:(BOOL) isFrameworkUse;
- (nullable SPMNewChinfoItem *)getNextNewChinfoItem: (BOOL) isFrameworkUse;
- (nullable SPMParams4ExtesionItem *)getNextExtensionItem: (BOOL) isFrameworkUse;
- (nullable SPMOpenIdItem *)getNextOpenIdItem:(BOOL) isFrameworkUse;
// set
- (void)setNextPageItem:(SPMFullGuideItem * _Nullable)nextPageItem;
- (void)setNextChinfoItem:(SPMNewChinfoItem * _Nullable)nextChinfoItem;
- (void)setNextExtensionItem:(SPMParams4ExtesionItem * _Nonnull)nextExtensionItem;
- (void)setNextOpenIdItem:(SPMOpenIdItem * _Nullable)nextOpenIdItem;

- (nullable NSDictionary *)getCurrentNextExtensionItemDict;

/**
 获取当前newChinfo
 @return newChinfo
 */
- (nullable NSString *)currentNextPageNewChinfo;

@property (nonatomic, copy) NSDictionary *config;

+ (NSUInteger)maxExtParamsLength;

@end

NS_ASSUME_NONNULL_END

