//
//  NXRConfiguration.h
//  NebulaResource
//
//  Created by chenwenhong on 15/9/16.
//  Copyright (c) 2015年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "NXRProtocol.h"

// 服务器环境
typedef NS_ENUM(NSUInteger, NXREnvironment) {
    NXREnvironment_Online = 0,  // 线上
    NXREnvironment_Pre,         // 预发
    NXREnvironment_Test,        // 测试
    NXREnvironment_Dev,         // 开发
};

// 渠道
typedef NS_ENUM(NSUInteger, NXRChannel) {
    NXRChannel_Offical = 0,     // 正式
    NXRChannel_RC,              // RC
};


@interface NXRConfiguration : NSObject

@property (nonatomic, readonly, copy) NSString *sdkVersion;                     // SDK版本号
@property (nonatomic, readonly, copy) NSString *systemVersion;                  // 设备系统版本号
@property (nonatomic, readonly, copy) NSString *platform;                       // 平台:ios
@property (nonatomic, assign) NSTimeInterval updateReqRate;           // 单个应用更新频率,过期后触发异步更新, default:30分钟
@property (nonatomic, assign) NSTimeInterval preReqRate;              // 单个应用'前置'更新频率,过期后触发同步更新, default:30天
@property (nonatomic, assign) NSTimeInterval forcePreReqRate;         // 单个应用'前置'强制更新频率,过期后触发同步强制更新，default:0（无效值）
@property (nonatomic, readonly, assign) NSTimeInterval limitReqRate;            // 单个应用限流频率, default:10分钟
@property (nonatomic, readonly, assign) NSTimeInterval resMainDocInvalidTime;   // 资源应用主文档失效时间, default:3天
@property (nonatomic, readonly, strong) NSMutableArray *commonAppList;          // 公共应用列表

@property (nonatomic, assign) NSInteger appPoolCapacity;                        // 应用池容量, default:3
@property (nonatomic, assign) NXREnvironment environment;                       // 服务器环境, default:NXREnvironment_Online
@property (nonatomic, assign) NXRChannel channel;                               // 应用渠道, default:NXRChannel_Offical
@property (nonatomic, assign) BOOL cacheReqTime;                                // 是否缓存更新时间,默认:否
@property (nonatomic, assign) BOOL userMode;                                    // 用户模式, 如需使用灰度功能等用户维度的功能此值必须配置YES, default:NO
@property (nonatomic, assign) NSTimeInterval prepareTimeLimit;                  // 准备应用超时时间, default:10s
@property (nonatomic, assign) BOOL enableSceneCheck;                            //是否检查服务器下发的scene字段，默认YES

@property (nonatomic, copy) NSString *internalConfigPath;                       // 配置文件路径,默认NXRConfig.plist
@property (nonatomic, copy) NSString *documentDirectoryPath;                    // 沙盒根目录, default:Documents
@property (nonatomic, copy) NSString *dataRootPath;                             // 数据总路径, default:Documents/NAMAPP
@property (nonatomic, copy) NSString *unzipRootPath;                            // 解压总路径, default:Documents/NAMAPP_UNZIP
@property (nonatomic, copy) NSString *downloadRootPath;                         // 下载总路径, default:Documents/NAMAPP_AMR
@property (nonatomic, copy) NSString *templateConfigRootPath;                   // 模版小程序配置信息总路径，default:Documents/TEMPLATECONFIG
@property (nonatomic, copy) NSString *presetApplistPath;                        // 预置应用列表路径, default:nil
@property (nonatomic, copy) NSString *presetAppPackagePath;                     // 预置离线资源包路径, default:nil
@property (nonatomic, copy) NSString *clientBundleId;                           // 客户端id, default:nil
@property (nonatomic, copy) NSString *clientVersion;                            // 客户端版本号, default:1.0.0.0
@property (nonatomic, copy) NSString *serverURLString4UpdateApps;               // 服务器地址:更新app
@property (nonatomic, strong) NSDictionary *grayRules;                          // 业务方自定义灰度规则列表
@property (nonatomic, assign) BOOL isNeedVerify;                                // 业务方指定是否开启验签，默认为YES
@property (nonatomic, strong) NSString *signPublicKey;                          // 业务方指定的验证包签名的公钥

@property (nonatomic, strong) NSDictionary *performanceOpt;                     //性能优化配置开关
@property (nonatomic, copy)  NSString *currentRegion;                           //当前地域
//是否允许转发index.html
@property (nonatomic, assign) BOOL                  enableUseAppxHtml;
//是否启用appxNG
@property (nonatomic, assign) BOOL                  enableUseAppxNG;
@property (nonatomic, assign) BOOL                  appxngAppId;
@property (nonatomic, assign) BOOL                  enableLogAppxNGError;
/**
 *  自定义代理
 */
@property (nonatomic, strong) id<NXRDynamicConfigProtocol> dynamicConfigManager;    // 动态配置
@property (nonatomic, strong) id<NXRDownloadProtocol> downloadManager;              // 下载
@property (nonatomic, strong) id<NXRZipArchiveProtocol> zipArchiveManager;          // 解压
@property (nonatomic, strong) id<NXRDataStorageProtocol> dataStorage;               // 存储
@property (nonatomic, strong) id<NXRRequestProtocol> requestManager;                // 请求
@property (nonatomic, strong) id<NXRLogProtocol> logManager;                        // Log
@property (nonatomic, strong) id<NXRAppInterface> appInterface;                     // App相关接口
@property (nonatomic, strong) id<NXRCreditProtocol> creditManager;                  // 智能列表
@property (nonatomic, strong) id<NXRTinyAppConfigProtocol> tinyappConfigManager;

//是否在离线包下载失败时，基于fallbackups地址重新下载一次
@property(nonatomic, assign) BOOL                   shouldRetryWhenDownloadFailWithFallbackUps;
// 离线包下载超时时间，默认 60，单位 S
@property(nonatomic, assign) NSTimeInterval         h5DownloadRetryTimeout;

/**
 *  动态根据配置文件配置代理
 */
- (void)presetMobileRuntime;

/**
 *  获取客户端配置
 */
- (id)serverConfigValueForKey:(NSString *)key  class:(Class)valueClass;

/**
 *  渠道名
 *
 *  Rc包: rc
 *  其他: offical
 */
- (NSString *)channelName;

/**
 *  环境名
 *
 *  预发环境:preppub 
 *  其他:production
 */
- (NSString *)environmentName;

/**
 *  获取通过代理过滤过的公共资源列表
 *
 *  可通过代理函数:supportNebulaApp配置是否支持为NebulaApp,如果为配置该协议默认返回配置的公共列表
 *  @return 过滤后的公共应用id及对应版本号, e.g. {'20000196':'1.0.0'}
 */
- (NSDictionary *)filteredCommonApplist;

/**
 *  添加公共资源应用ID
 *
 *  @param list 应用id列表, e.g. ['20000196','20000202']
 */
- (void)addCommonApps:(NSArray *)list;

#if NB_INSIDE
@property (nonatomic, copy) NSString *insideCustomPresetBundleName;                 // Inside运行客户自定义自己的预制包bundle

@property (nonatomic, copy) NSString *insideCustomPresetApplistPath;                 // Inside运行客户自定义自己的预制包配置plist

@property (nonatomic, assign) BOOL isNonLoginPackageEnabled;                        // Inside是否允许线下包不经过鉴权直接拉包
#endif
@end



#pragma mark - Unavalilable

@interface NXRConfiguration (UNAVAILABLE)

/**
 *  不可分配内存空间
 */
+ (instancetype)new UNAVAILABLE_ATTRIBUTE;

/**
 *  不可初始化
 */
- (instancetype)init UNAVAILABLE_ATTRIBUTE;

/**
 *  不可重写
 */
- (id)copy UNAVAILABLE_ATTRIBUTE;

@end

#ifdef __cplusplus
extern "C" {
#endif
    
    NXRConfiguration * NXRConfigurationGet();
    
#ifdef __cplusplus
}
#endif
