//
//  NXEngineRender.h
//  NebulaEngine
//
//  Created by lyusheng on 2019/7/31.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AriverKernel/AriverKernel.h>
#import <NebulaEngine/NXEngineViewParam.h>
#import <NebulaEngine/NXEngineInstance.h>
#import <NebulaEngine/NXEngineDefines.h>

NS_ASSUME_NONNULL_BEGIN

@protocol NXEngineCreateRender<NSObject>
@required
- (BOOL)canHandleEngineLaunch:(RVKSession *)session result:(NXEngineLaunchParam *_Nullable*_Nullable)launchParam;
- (void)onEngineCreate:(NXEngineInstance *)engineInstance session:(RVKSession *)session;
- (BOOL)canHandleCreateView:(RVKView *)view result:(NXEngineViewParam *_Nullable*_Nullable)contentViewParam;
- (Class)renderClass;
- (NSString *)renderResourceTag; // render所用的资源版本号
@end

#define kEngineEvent_Engine_Create @"kEngineEvent_Engine_Create"
#define kEngineEvent_View_Will_Create   @"kEngineEvent_View_Will_Create"


@interface NXERenderManager : NSObject<NXEngineCreateRender>

+ (instancetype)sharedInstance;

- (void)registerRender:(Class)render alias:(NSString *)renderAlias;

- (id<NXEngineView>)createView:(RVKView *)view;

@end

NS_ASSUME_NONNULL_END
