//
//  NXEngineInstance.h
//  NebulaEngine
//
//  Created by lyusheng on 2019/7/31.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN
@protocol NXEngineCreateRender;
typedef NS_ENUM(NSInteger, NXERenderType  ) {
    NXERenderTypeDefault = 0,
    NXERenderTypeCubeApp,  // 完整Cube
    NXERenderTypePageCube,    // 单页Cube
    NXERenderTypePaladin      // paladin
};

@interface NXEngineLaunchParam : NSObject
@property(nonatomic,strong)NSString *appId;
@property(nonatomic,strong)NSMutableDictionary *options;
+ (instancetype)paramsWithAppId:(NSString *)appId;
@property(nonatomic) BOOL prepareCubeParamFail;
@property(nonatomic)NSDictionary *latestCubeFMInfo;
@property(nonatomic) NXERenderType renderType;
@property(nonatomic,weak) id<NXEngineCreateRender> renderCreator;
@end

@protocol CKView;
@interface NXEngineInstance : NSObject

@property(nonatomic,strong) NXEngineLaunchParam *params;
@property(nonatomic, copy) NSString *jsfmError;
@property(nonatomic,assign)BOOL forceDowngrade; // 1. prepareCubeParam出错，2.startCube时返回jsfmError
@property(nonatomic) Class originSessionContentViewCls; // 用于保存session初始化过程中的contentViewCls，用于downgrade.

@property(nonatomic) NSMutableDictionary<NSString *,UIView<CKView>*> *pageCubeDict; // key: url path, e.g. www/a.html
@property(nonatomic,strong) id renderAppHolder;             // 具体渲染引擎的对象

- (NSString*)launchIndentifier;
- (void)onFatalError:(RVKSession *)session;
- (NXERenderType)renderType;

+ (NSString *)cachedFatalErrorValForKey:(NSString *)key;
+ (void)updateCachedFatalErrorKey:(NSString *)key value:(NSString *)value;
@end

NS_ASSUME_NONNULL_END
