//
//  NXEJSAPIHandlerDefine.h
//  NebulaEngine
//
//  Created by lyusheng on 2019/8/22.
//  Copyright © 2019 Alipay. All rights reserved.
//

#ifndef NXEngineHandlerDefine_h
#define NXEngineHandlerDefine_h

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef void(^NXEngineHandlerCallback)(id result, NSError * _Nullable error);

// --------------------------------------------------------------------------------------------------------
@protocol NXEEngineProtocol <NSObject>
- (NSString *)appVersion;// app product version
- (NSString *)currentLanguage;// 语言设置
- (NSString *)productType;// rc/test/dev
@end

// --------------------------------------------------------------------------------------------------------
@protocol NXERemoteImageHandler
@required
//- (NSString *)fetchImage:(NSString *)url size:(CGSize)size callback:(void (^)(UIImage *image,NSError *error))callback;
- (NSString *)fetchImage:(NSString *)url appId:(NSString *)appId size:(CGSize)size callback:(void (^)(UIImage *image,NSError *error))callback;
- (BOOL)cancelWithTaskId:(NSString *)taskId;
@end
// --------------------------------------------------------------------------------------------------------
@protocol NXEScrollViewHandler
@required
- (void)scrollViewDidScrollInView:(UIView *)rootView scrollOffset:(CGPoint)offset option:(NSDictionary *)option;
@end

// --------------------------------------------------------------------------------------------------------

@protocol NXEngineLogHandler
@required

//- (void)printLog:(NSString *)log apLoglevel:(NSInteger)level;

- (void)reportPerformenceInfo:(NSString *)performenceType
                         cost:(double)costInMs
                      session:(RVKSession *)session
                         page:(RVKPage *)page
                    extraInfo:(NSDictionary *)extraInfo;

- (void)reportException:(NSString *)message
                   type:(NSString *)exceptionType
                session:(RVKSession *)session
                   page:(RVKPage *)page
              extraInfo:(NSDictionary *)info;

- (void)eventMonitor:(NSString *)type
             subType:(NSString *)subType
             session:(RVKSession *)session
                page:(RVKPage *)page
           extraInfo:(NSDictionary *)info;

@end

// --------------------------------------------------------------------------------------------------------

@protocol NXEngineJSAPIHandler <NSObject>

@required

/**
 * 调用jsApi，异步调用
 *
 * @param methodName jsApi名
 * @param params 调用参数
 * @param appInstanceID 调用来源的 app ID
 * @param pageInstanceID 调用来源的 page ID
 * @param callback 回调对象
 */
- (void)callJSApi:(NSString *_Nonnull)methodName params:(nullable NSDictionary *)params appInstanceID:(NSString *_Nonnull)appInstanceID pageInstanceID:(NSString *_Nonnull)pageInstanceID callback:(NXEngineHandlerCallback _Nonnull)callback;

/**
 * 调用jsApi，同步调用
 *
 * @param methodName jsApi名
 * @param params 调用参数
 * @param appInstanceID 调用来源的 app ID
 * @param pageInstanceID 调用来源的 page ID
 * @return jsApi处理结果
 */
- (nullable id)callJSApi:(NSString *_Nonnull)methodName params:(nullable NSDictionary *)params appInstanceID:(NSString *_Nonnull)appInstanceID pageInstanceID:(NSString *_Nonnull)pageInstanceID;


@end

// --------------------------------------------------------------------------------------------------------

//extern NSString *const CKImageAppInstanceIDKey; // 触发加载图片对应的 app instance ID
//extern NSString *const CKImagePageInstanceIDKey; // 触发加载图片对应的 page instance ID


@protocol NXEImageHandler <NSObject>

@required
- (NSString*)fetchImage:(NSString *)url size:(CGSize)size option:(NSDictionary *)option callback:(NXEngineHandlerCallback)callback;

@optional
- (void)cancel:(NSString*)fetchID;

@end

NS_ASSUME_NONNULL_END

#endif /* NXEngineHandlerDefine_h */
